# twoStepsBenchmark works

    Code
      twoStepsBenchmark(mensualts, trimts, include.differenciation = TRUE)
    Output
      
      Call:
      twoStepsBenchmark(hfserie = mensualts, lfserie = trimts, include.differenciation = TRUE)
      
      Coefficients:
      constant   hfserie  
       13.9409   -0.2365  
      
                    Jan          Feb          Mar          Apr          May
      2010                                        -13.22506554 -11.71372098
      2011  -1.19387013   0.08590658   1.10796354   2.61006491   4.17807049
      2012  15.45056091  16.54021287  17.50542088  18.65068625  19.76940010
                    Jun          Jul          Aug          Sep          Oct
      2010 -10.72873730  -9.11931306  -7.82345954  -6.91584498  -5.46078545
      2011   5.52777964   7.09374325   8.43906493   9.89280103  11.72185029
      2012  21.15126679  22.12815363  23.08607327  24.55394736  26.06811624
                    Nov          Dec
      2010  -4.03665203  -2.57391349
      2011  12.97733182  14.35112611
      2012                          

---

    Code
      bn
    Output
      
      Call:
      twoStepsBenchmark(hfserie = mensualts, lfserie = trimts, include.differenciation = TRUE)
      
      Coefficients:
      constant   hfserie  
       14.9712   -0.2195  
      
                  Jan        Feb        Mar        Apr        May        Jun
      2010                       -15.335290 -13.894557 -12.642315 -10.972712
      2011  -1.381719  -0.042100   1.423819   2.823091   4.287695   5.709639
      2012  15.720840  16.958585  18.323328  19.604758  20.855109  22.183005
                  Jul        Aug        Sep        Oct        Nov        Dec
      2010  -9.679282  -8.333996  -6.979398  -5.597955  -4.016959  -2.757334
      2011   7.212468   8.360927   9.837019  11.270042  12.530967  14.038771
      2012  24.077039  25.305380  26.645391                                 

---

    Code
      twoStepsBenchmark(turnover, construction, include.differenciation = TRUE,
        include.rho = TRUE)
    Output
      
      Call:
      twoStepsBenchmark(hfserie = turnover, lfserie = construction, 
          include.differenciation = TRUE, include.rho = TRUE)
      
      Coefficients:
      constant   hfserie  
       -1.4628    0.1658  
      
                Jan      Feb      Mar      Apr      May      Jun      Jul      Aug
      2000 11.18206 11.04866 11.30853 11.38104 11.47692 11.49751 11.71882 11.65895
      2001 11.88900 12.04226 11.99001 11.92215 11.97729 11.95709 11.75578 12.11881
      2002 12.04639 11.99580 12.01635 12.33792 12.28315 12.23914 12.22651 12.40591
      2003 12.54442 12.73336 12.74881 12.77787 12.61749 12.92968 12.98524 13.24092
      2004 13.73072 13.75242 13.74804 14.00732 13.99253 14.02142 14.17507 13.98141
      2005 14.53184 14.59302 14.68313 14.83277 14.82667 14.93288 15.24826 15.34354
      2006 15.76601 15.94048 16.15560 16.15741 16.49926 16.67063 16.80853 16.74555
      2007 17.61591 17.78962 17.87036 17.75800 18.19025 18.16830 18.12346 18.12180
      2008 18.92701 19.03107 19.44082 19.04166 18.81393 19.06980 19.01261 19.10107
      2009 18.04609 17.97183 17.87240 17.86220 17.60670 17.61955 17.66419 17.47036
      2010 17.32424 17.03802 17.01274 17.08199 17.31522 17.48523 17.60756 17.52103
      2011 18.05156 18.08096 18.22196 18.27127 18.42152 18.27492 18.73944 18.25089
      2012 18.45104 18.18650 18.48644 18.42650 18.50758 18.32755 18.63630 18.30627
      2013 18.34021 18.07861 17.67714 18.32797 18.30978 18.17398 18.44345 18.53542
      2014 17.93146 18.28780 18.24397 18.12033 17.83074 18.34096 17.89400 18.43781
      2015 17.52809 17.47668 17.45319 17.37109 17.03633 17.45859 17.36123 17.26776
      2016 17.26094 17.55480 17.24287 17.14100 17.54099 17.15198 17.19781 17.22610
      2017 17.76803 17.97787 18.42889 17.63150 18.75671 19.02973 18.59849 18.33591
      2018 19.12903 19.17248 18.49080 19.25619 18.71611 19.39149 18.99632 19.58997
      2019 19.86381 20.12433 20.58937 20.58685 20.56888 20.04475 20.06336 21.21048
      2020 20.51222 19.71799 18.75753 16.25575 14.92516                           
                Sep      Oct      Nov      Dec
      2000 11.70021 11.73678 11.73296 11.95756
      2001 11.81373 12.15460 12.09583 12.18346
      2002 12.43690 12.55239 12.32945 12.43011
      2003 13.17545 13.33334 13.34199 13.47142
      2004 14.33490 14.45943 14.52438 14.57234
      2005 15.49567 15.48353 15.85800 15.57070
      2006 16.94003 16.87594 17.13380 17.50677
      2007 18.22127 18.35260 18.06905 18.41939
      2008 18.88760 18.93812 18.33361 18.40270
      2009 17.30808 17.41285 17.34143 17.62433
      2010 17.87258 17.76338 18.12096 17.95703
      2011 18.35222 18.31471 18.75703 18.76352
      2012 18.18506 18.33356 18.02702 18.02619
      2013 18.35993 18.25882 18.66823 18.92647
      2014 17.98088 17.88134 17.57529 17.77542
      2015 17.25076 17.38444 17.56184 17.34999
      2016 17.67069 17.54678 17.83421 17.63182
      2017 18.54037 18.55957 18.72319 19.24975
      2018 19.27087 19.82568 19.59630 19.86477
      2019 20.62628 20.47542 20.52958 20.41689
      2020                                    

# mts works

    Code
      bn
    Output
      
      Call:
      twoStepsBenchmark(hfserie = ts(matrix(rnorm(900, 0, 100), ncol = 3), 
          start = c(2000, 1), freq = 12) %>% `colnames<-`(c("a", "b", 
          "c")), lfserie = construction)
      
      Coefficients:
       constant          a          b          c  
      195.92267   -0.04149    0.04151   -0.03095  
      
                  Jan        Feb        Mar        Apr        May        Jun
      2000  8.9191558 12.9306806  8.8982857 15.5713986 12.4967904 23.0869095
      2001 15.2869162 12.2073564 27.8983736  8.0689454 13.7003714 16.0877242
      2002 29.7242356 10.3384906 13.0225735 21.3499582 12.4604077  8.4856501
      2003  9.2314051  8.1952616  8.8071680 20.0895829 21.3544841  6.0227980
      2004  6.6303480 10.7262339 24.4171028 16.7715225 13.1558522 17.6765666
      2005 13.5783468  1.4121441 14.0240082 13.4652621 23.5198453  2.1607070
      2006 14.5522945 14.3710855 22.8532183 17.0330312 18.8009321 15.2492176
      2007 16.6789993 19.7514089 18.5696153 26.4853791 18.2192406  6.5755761
      2008 17.8885518 18.2244005 15.1572600 18.1028252 20.3657769 15.6009484
      2009  4.0682301  6.5681735 18.2887625 18.5962724 28.9742321 24.0960443
      2010 21.2764277 19.8412229 18.5319926 12.6481714 28.7500145 16.2671813
      2011 17.5159537 16.6008294 15.4379095 19.6418785 29.7723430  8.0066752
      2012 20.6359562 11.2409785 12.4485180 29.0450297 27.8560498 24.6754915
      2013 10.5717984 19.6842910 15.3909812  8.2383169 22.3224000 16.3073964
      2014 14.1026599  7.7772796 21.0298217 17.2646142 28.1581418 19.9823536
      2015 19.1755787 20.3459446 12.0443190 22.7866604  7.0739878 13.7777647
      2016 18.9567217 11.2893188 15.1248433  7.1197011 17.8324875 21.0813804
      2017 19.1102830 24.9788467 15.1063347  8.5716745 11.5628993 26.6716657
      2018 25.6504750 14.6280603 21.7840078 25.8935466 21.4854104 16.0306614
      2019 18.1000882 17.8531041 16.5083238 17.6731359 18.6768366 28.2574678
      2020 19.9301452 23.4059260 20.7984037  7.2617049 14.5336352 23.9071501
      2021 15.6001245  8.0087784 18.2337688  5.1723630 18.8949263 13.3511340
      2022 13.4049049 16.2957307 13.2208742 14.6112655 22.3219438 25.1938067
      2023 21.4655444 13.1181520 17.9597036  8.1935700 21.0256590 27.2334741
      2024 12.4271361 10.7531829 13.3334222 12.8642849 22.8532867  8.9541535
                  Jul        Aug        Sep        Oct        Nov        Dec
      2000  9.6323827 14.6191697  9.1797676  2.0401035 12.0717884  8.9535676
      2001  7.6709583 23.4964492  2.4403646 -0.7203035 -2.8681323 20.6309763
      2002 15.1285272  2.6047617  1.9850059  8.3257012 19.6153699  4.2593184
      2003 18.4605343 16.5263728 10.4235894 16.7574758 14.1956534  5.8356746
      2004 14.1493983 16.0598124 15.5978810 17.5518442  9.3943619  7.1690761
      2005 15.5528173 25.8700971 16.5580791 13.9583146 20.2058098 21.0945687
      2006 13.5388954  8.6861116 23.4986898 15.2154778 16.5008053 18.9002409
      2007  6.7398348 23.3637176 28.2014401 14.8522784 11.6104825 25.6520272
      2008 20.0589578 17.0377865 17.7701217 15.7725657 16.4577548 34.5630507
      2009 24.5711608 19.7456630 29.5188232 13.0260610  6.0398228 18.3067543
      2010 23.0370056 17.1961346  7.6749669 13.8713562  9.5712995 21.4342267
      2011  7.4779026 25.9537902 20.2374393 17.9815345 19.6467690 22.2269751
      2012 16.7548441 24.0304694 14.5128719 14.5548381 10.7431801 13.4017726
      2013 27.7700593 25.9731014 17.8305032 23.1996458 29.8782385  2.9332679
      2014  5.9469177 24.5597764 24.0196505 15.3897190 19.4164653 18.6526002
      2015 15.3252074 20.5807804 22.5837298 22.1012533 15.5899559 17.1148181
      2016 12.9926464 19.6655634 26.5917290 27.1867839 13.2451434 17.9136812
      2017 10.9062095 27.5308209 23.7964211 15.8612417 18.3514357 19.1521672
      2018 28.0410408 15.6195893  9.6256232 18.9953010 34.0821481 -0.5358640
      2019 12.1728159 22.3718589 23.4784211 27.1089091 15.4171608 27.4818778
      2020 16.7180472 14.8700940  4.7701515 15.2378236 20.1625497 25.4526443
      2021 19.4439714  6.6494441 27.3058110 17.8276071 19.0864253 20.7508808
      2022 16.5566692 13.6967987  7.3334929 24.4146842 19.2607141 13.8316095
      2023 23.2356175 20.6970876 32.0529193 19.9211867 18.2516009 34.4468806
      2024 17.1529147  6.3620464 17.4421166 17.3337470 14.2662787 19.7290736

# reUseBenchmark works

    Code
      benchmark2
    Output
      
      Call:
      reUseBenchmark(hfserie = adjusted_turnover, benchmark = benchmark1)
      
      Coefficients:
      constant   hfserie    LS2009  
      -0.86421   0.16072  -0.03049  
      
                Jan      Feb      Mar      Apr      May      Jun      Jul      Aug
      2006 15.79839 15.95398 16.17784 16.19372 16.52072 16.65257 16.80767 16.70937
      2007 17.64613 17.80150 17.89493 17.79928 18.21234 18.15455 18.12957 18.08707
      2008 18.93205 19.01492 19.42438 19.04996 18.82465 19.03961 19.00823 19.06077
      2009 18.14233 18.03862 17.93930 17.92516 17.65470 17.61436 17.66045 17.41663
      2010 17.30397 17.02410 17.02448 17.11372 17.34189 17.47734 17.62073 17.50144
      2011 18.09488 18.10517 18.25245 18.30958 18.44605 18.26482 18.73159 18.21583
      2012 18.47750 18.20354 18.50549 18.45733 18.52731 18.31422 18.63050 18.26888
      2013 18.37138 18.10047 17.72267 18.36345 18.33710 18.16666 18.44456 18.49153
      2014 17.97196 18.29900 18.26679 18.15577 17.86518 18.31971 17.90191 18.38554
      2015 17.56229 17.49285 17.47941 17.40801 17.07331 17.44255 17.36390 17.23040
      2016 17.28984 17.55732 17.26667 17.17863 17.55875 17.14442 17.20746 17.19503
      2017 17.80352 17.99282 18.44453 17.68472 18.76978 18.99869 18.60043 18.30675
      2018 19.15573 19.18228 18.53462 19.28811 18.75754 19.37496 19.01017 19.54491
      2019 19.88289 20.11951 20.58423 20.59549 20.57429 20.03354 20.07555 21.15369
                Sep      Oct      Nov      Dec
      2006 16.95674 16.86513 17.11191 17.45198
      2007 18.23801 18.33079 18.04706 18.35877
      2008 18.91817 18.94454 18.36374 18.41898
      2009 17.29943 17.35264 17.26132 17.49507
      2010 17.90135 17.76478 18.10543 17.92076
      2011 18.36791 18.29702 18.71751 18.69720
      2012 18.20569 18.31551 18.01053 17.98350
      2013 18.37521 18.24244 18.63066 18.85387
      2014 17.99506 17.86239 17.55566 17.72104
      2015 17.26722 17.36182 17.52520 17.29306
      2016 17.68243 17.53065 17.80410 17.58470
      2017 18.56165 18.54842 18.70128 19.18741
      2018 19.29082 19.79521 19.56561 19.80004
      2019 20.65079 20.48055 20.53635 20.41311

---

    Code
      benchmark3
    Output
      
      Call:
      reUseBenchmark(hfserie = adjusted_turnover, benchmark = benchmark1, 
          reeval.smoothed.part = TRUE)
      
      Coefficients:
      constant   hfserie    LS2009  
      -0.86421   0.16072  -0.03049  
      
                Jan      Feb      Mar      Apr      May      Jun      Jul      Aug
      2006 15.84103 15.98385 16.19645 16.20257 16.52132 16.64642 16.79627 16.69423
      2007 17.63484 17.79359 17.89000 17.79694 18.21218 18.15618 18.13259 18.09108
      2008 18.93504 19.01702 19.42568 19.05058 18.82469 19.03918 19.00743 19.05970
      2009 18.14154 18.03806 17.93895 17.92499 17.65468 17.61447 17.66067 17.41691
      2010 17.30418 17.02425 17.02457 17.11377 17.34190 17.47731 17.62067 17.50136
      2011 18.09482 18.10513 18.25243 18.30957 18.44605 18.26483 18.73160 18.21585
      2012 18.47752 18.20354 18.50550 18.45734 18.52731 18.31421 18.63050 18.26887
      2013 18.37138 18.10047 17.72268 18.36345 18.33710 18.16667 18.44456 18.49153
      2014 17.97195 18.29898 18.26677 18.15575 17.86517 18.31970 17.90191 18.38554
      2015 17.56234 17.49290 17.47947 17.40806 17.07336 17.44259 17.36392 17.23040
      2016 17.28965 17.55710 17.26645 17.17841 17.55856 17.14428 17.20739 17.19504
      2017 17.80424 17.99364 18.44539 17.68555 18.77050 18.99923 18.60073 18.30672
      2018 19.15302 19.17917 18.53136 19.28499 18.75482 19.37291 19.00907 19.54501
      2019 19.89312 20.13128 20.59652 20.60729 20.58456 20.04128 20.07972 21.15329
                Sep      Oct      Nov      Dec
      2006 16.93936 16.84702 17.09457 17.43691
      2007 18.24261 18.33558 18.05165 18.36276
      2008 18.91696 18.94327 18.36252 18.41793
      2009 17.29975 17.35297 17.26165 17.49535
      2010 17.90126 17.76469 18.10535 17.92069
      2011 18.36793 18.29704 18.71753 18.69722
      2012 18.20569 18.31551 18.01052 17.98349
      2013 18.37521 18.24244 18.63065 18.85386
      2014 17.99506 17.86240 17.55569 17.72108
      2015 17.26719 17.36176 17.52510 17.29292
      2016 17.68254 17.53088 17.80448 17.58524
      2017 18.56123 18.54753 18.69985 19.18538
      2018 19.29241 19.79856 19.57097 19.80770
      2019 20.64478 20.46792 20.51607 20.38416

# annualBenchmark

    Code
      annualBenchmark(turnover, construction, end.coeff.calc = 2018)
    Output
      
      Call:
      annualBenchmark(hfserie = turnover, lfserie = construction, end.coeff.calc = 2018)
      
      Coefficients:
      constant   hfserie  
       41.6754    0.1437  
      
                Jan      Feb      Mar      Apr      May      Jun      Jul      Aug
      2000 11.18790 11.08078 11.31418 11.38489 11.47555 11.50064 11.69937 11.65411
      2001 11.88193 12.01952 11.97872 11.92408 11.97574 11.96180 11.79062 12.10821
      2002 12.05586 12.01403 12.03441 12.31620 12.27237 12.23841 12.23219 12.39292
      2003 12.54736 12.71961 12.74204 12.77681 12.64795 12.92918 12.98854 13.22188
      2004 13.71327 13.74605 13.75573 13.99343 13.99310 14.03014 14.17481 14.01798
      2005 14.54266 14.60508 14.69341 14.83418 14.84083 14.94564 15.23258 15.32963
      2006 15.78078 15.95041 16.15501 16.17447 16.48836 16.65423 16.79083 16.75307
      2007 17.58744 17.75357 17.83921 17.75761 18.14808 18.14503 18.12223 18.13697
      2008 18.91708 19.02044 19.38523 19.04550 18.85084 19.07183 19.01801 19.08694
      2009 18.08170 17.99428 17.88715 17.85944 17.62123 17.61768 17.64379 17.46531
      2010 17.31764 17.07088 17.05157 17.11551 17.32286 17.47674 17.59060 17.52477
      2011 18.05003 18.08948 18.22389 18.27708 18.41600 18.29590 18.70367 18.28371
      2012 18.44809 18.21415 18.47006 18.41473 18.48226 18.32415 18.59029 18.30348
      2013 18.33864 18.11388 17.76740 18.33242 18.31714 18.19944 18.43248 18.51120
      2014 17.97551 18.28037 18.23788 18.12570 17.86916 18.30525 17.91126 18.37539
      2015 17.54318 17.48958 17.46096 17.38231 17.08547 17.44549 17.35595 17.27056
      2016 17.25440 17.50984 17.24153 17.15653 17.50772 17.17640 17.22318 17.25602
      2017 17.78621 17.98246 18.38750 17.71038 18.69925 18.94935 18.58887 18.37433
      2018 19.12339 19.17124 18.58896 19.25910 18.79618 19.38493 19.04421 19.55876
      2019 19.77105 19.99741 20.40999 20.42633 20.43823 20.02044 20.08199 21.13052
      2020 20.93178 20.33328 19.58131 17.48417 16.39264       NA       NA       NA
      2021       NA       NA       NA       NA       NA       NA       NA       NA
                Sep      Oct      Nov      Dec
      2000 11.69617 11.73387 11.73625 11.93629
      2001 11.84649 12.14429 12.09544 12.17316
      2002 12.42558 12.53201 12.34568 12.44033
      2003 13.17743 13.32712 13.34799 13.47408
      2004 14.33485 14.45280 14.51862 14.56923
      2005 15.47679 15.48242 15.82396 15.59282
      2006 16.93817 16.89891 17.13840 17.47738
      2007 18.23943 18.36960 18.14032 18.46050
      2008 18.89071 18.91979 18.37771 18.41592
      2009 17.31628 17.40077 17.33467 17.57772
      2010 17.83992 17.75707 18.08006 17.95239
      2011 18.37322 18.34065 18.72217 18.72422
      2012 18.19828 18.32748 18.06297 18.06405
      2013 18.35764 18.26806 18.62042 18.84127
      2014 17.97170 17.87720 17.60321 17.76736
      2015 17.25222 17.36525 17.51695 17.33207
      2016 17.65091 17.55437 17.81557 17.65353
      2017 18.56432 18.59353 18.74767 19.21613
      2018 19.28058 19.75809 19.55429 19.78027
      2019 20.68757 20.62914 20.75737 20.74995
      2020       NA       NA       NA       NA
      2021       NA       NA       NA       NA

