% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_discord_regression.R
\name{discord_regression}
\alias{discord_regression}
\title{Perform a Linear Regression within the Discordant Kinship Framework}
\usage{
discord_regression(
  data,
  outcome,
  predictors,
  id = "extended_id",
  sex = "sex",
  race = "race",
  pair_identifiers = c("_s1", "_s2")
)
}
\arguments{
\item{data}{A data frame.}

\item{outcome}{A character string containing the outcome variable of
interest.}

\item{predictors}{A character vector containing the column names for
predicting the outcome.}

\item{id}{A unique kinship pair identifier.}

\item{sex}{A character string for the sex column name.}

\item{race}{A character string for the race column name.}

\item{pair_identifiers}{A character vector of length two that contains the variable identifier for each kinship pair.}
}
\value{
A tidy dataframe containing the model metrics via the
  \link[broom]{tidy} function.
}
\description{
Perform a Linear Regression within the Discordant Kinship Framework
}
\examples{

discord_regression(data = sample_data,
outcome = "height",
predictors = "weight",
pair_identifiers = c("_s1", "_s2"),
sex = NULL,
race = NULL)

}
