% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_acp_utils.R
\name{hcpcabi}
\alias{hcpcabi}
\title{PCA biplot}
\usage{
hcpcabi(
  modelo,
  axes = c(1, 2),
  nombrearchivo = NULL,
  colorInd = "steelblue",
  colorVar = "forestgreen",
  cos2Ind = 0,
  cos2Var = 0,
  colorIndCos = "firebrick",
  colorVarCos = "darkorchid",
  titulos = c("Bien Representados", "Mal Representados")
)
}
\arguments{
\item{modelo}{an object of class PCA [FactoMineR].}

\item{axes}{a numeric vector of length 2 specifying the dimensions to be plotted.}

\item{nombrearchivo}{a character value specifying the name to use when the plot is downloaded.}

\item{colorInd}{a color for the individuals well represented.}

\item{colorVar}{a color for the variables well represented.}

\item{cos2Ind}{a numeric value from 0 to 1 specifying the quality of the individuals.}

\item{cos2Var}{a numeric value from 0 to 1 specifying the quality of the variables.}

\item{colorIndCos}{a color for the individuals badly represented.}

\item{colorVarCos}{a color for the variables badly represented.}

\item{titulos}{a character vector of length 2 specifying the titles to use on legend.}
}
\value{
Highchart plot
}
\description{
PCA biplot
}
\examples{
p <- discoveR:::PCA(iris[, -5], graph = FALSE)
hcpcabi(p)

}
\author{
Diego Jimenez <diego.jimenez@promidat.com>
}
