% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq_fiml.R
\docType{class}
\name{eq_fiml-class}
\alias{eq_fiml-class}
\title{Equilibrium model estimated using full-information maximum likelihood.}
\description{
The equilibrium model consists of thee equations. The demand, the
supply and the market clearing equations. This model is estimated using full information
maximum likelihood.

\deqn{D_{nt} = X_{d,nt}'\beta_{d} + P_{nt}\alpha_{d} + u_{d,nt},}
\deqn{S_{nt} = X_{s,nt}'\beta_{s} + P_{nt}\alpha_{s} + u_{s,nt},}
\deqn{Q_{nt} = D_{nt} = S_{nt}.}
}
\examples{
simulated_data <- simulate_model_data(
  "eq_fiml", 500, 3, # model type, observed entities and time points
  -0.9, 14.9, c(0.3, -0.2), c(-0.03, -0.01), # demand coefficients
  0.9, 3.2, c(0.3), c(0.5, 0.02) # supply coefficients
)

# initialize the model
model <- new(
  "eq_fiml", # model type
  c("id", "date"), "Q", "P", # keys, quantity, and price variables
  "P + Xd1 + Xd2 + X1 + X2", "P + Xs1 + X1 + X2", # equation specifications
  simulated_data, # data
  use_correlated_shocks = TRUE # allow shocks to be correlated
)
}
