% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_base.R, R/diseq_base.R, R/eq_2sls.R,
%   R/eq_fiml.R
\name{estimate}
\alias{estimate}
\alias{estimate,diseq_base-method}
\alias{estimate,eq_2sls-method}
\alias{estimate,eq_fiml-method}
\title{Model estimation.}
\usage{
estimate(object, ...)

\S4method{estimate}{diseq_base}(
  object,
  use_numerical_gradient = FALSE,
  use_numerical_hessian = TRUE,
  use_heteroscedasticity_consistent_errors = FALSE,
  cluster_errors_by = NA,
  ...
)

\S4method{estimate}{eq_2sls}(object, ...)

\S4method{estimate}{eq_fiml}(
  object,
  use_heteroscedasticity_consistent_errors = FALSE,
  cluster_errors_by = NA,
  ...
)
}
\arguments{
\item{object}{A model object.}

\item{...}{Named parameter used in the model's estimation. These are passed further down
to the estimation call. For the \code{\linkS4class{eq_2sls}} model, the parameters a passed
to \code{\link[systemfit]{systemfit}}. For the rest of the models, the parameters are passed
to \code{\link[bbmle]{mle2}}.}

\item{use_numerical_gradient}{If true, the gradient is calculated numerically. By default,
all the models are estimated using the analytic expressions of their likelihoods'
gradients.}

\item{use_numerical_hessian}{If true, the variance-covariance matrix is calculated using
the numerically approximated Hessian. Calculated Hessians are available for the basic
and directional models.}

\item{use_heteroscedasticity_consistent_errors}{If true, the variance-covariance matrix is
calculated using heteroscedasticity adjusted (Huber-White) standard errors.}

\item{cluster_errors_by}{A vector with names of variables belonging in the data of the
model. If the vector is supplied, the variance-covariance matrix is calculated by
grouping the score matrix based on the passed variables.}
}
\value{
The object that holds the estimation result.
}
\description{
With the exception of \code{\linkS4class{eq_2sls}} all model are estimated by maximum
likelihood. The likelihood estimation is
using \code{\link[bbmle]{mle2}}. If no starting values are
provided, the function uses linear regression estimates as initializing values.
The default optimization method is
BFGS. For other alternatives see \code{\link[bbmle]{mle2}}. The \code{\linkS4class{eq_2sls}} is
estimated using two stage least squares. The implementation is based on
\code{\link[systemfit]{systemfit}}.
}
\section{Functions}{
\itemize{
\item \code{estimate,diseq_base-method}: Disequilibrium model estimation.

\item \code{estimate,eq_2sls-method}: Equilibrium model estimation.

\item \code{estimate,eq_fiml-method}: Equilibrium model estimation.
}}

\examples{
\donttest{
simulated_data <- simulate_model_data(
  "diseq_basic", 500, 3, # model type, observed entities, observed time points
  -0.9, 8.9, c(0.3, -0.2), c(-0.03, -0.01), # demand coefficients
  0.9, 4.2, c(0.03), c(-0.05, 0.02) # supply coefficients
)

# initialize the model
model <- new(
  "diseq_basic", # model type
  c("id", "date"), "Q", "P", # keys, quantity, and price variables
  "P + Xd1 + Xd2 + X1 + X2", "P + Xs1 + X1 + X2", # equation specifications
  simulated_data, # data
  use_correlated_shocks = TRUE # allow shocks to be correlated
)

# estimate the model object (by default the maximum optimization is using BFGS)
est <- estimate(model)

# estimate the model by specifying the optimization details that are passed to the optimizer.
est <- estimate(model, control = list(reltol = 1e-4), method = "BFGS")
}
}
