% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disequilibrium_model.R
\name{marginal_effect_at_mean}
\alias{marginal_effect_at_mean}
\alias{marginal_effect_at_mean,disequilibrium_model-method}
\title{Marginal effects at the mean.}
\usage{
marginal_effect_at_mean(object, estimation, variable)

\S4method{marginal_effect_at_mean}{disequilibrium_model}(object, estimation, variable)
}
\arguments{
\item{object}{A disequilibrium model object.}

\item{estimation}{A model estimation object (i.e. a \code{\link[bbmle]{mle2}} object).}

\item{variable}{Variable name for which the effect is calculated.}
}
\value{
The marginal effect of the passed variable evaluated at the estimated mean.
}
\description{
Returns the estimated marginal effects evaluated at the mean of a variable.
}
\examples{
\donttest{
simulated_data <- simulate_model_data(
  "diseq_basic", 500, 3, # model type, observed entities, observed time points
  -0.9, 8.9, c(0.3, -0.2), c(-0.03, -0.01), # demand coefficients
  0.9, 4.2, c(0.03), c(-0.05, 0.02) # supply coefficients
)

# initialize the model
model <- new(
  "diseq_basic", # model type
  c("id", "date"), "Q", "P", # keys, quantity, and price variables
  "P + Xd1 + Xd2 + X1 + X2", "P + Xs1 + X1 + X2", # equation specifications
  simulated_data, # data
  correlated_shocks = TRUE # allow shocks to be correlated
)

# estimate a model object
est <- estimate(model)

# get the marginal effects at the mean of variable "X1"
marginal_effect_at_mean(model, est, "X1")
}
}
