% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R, R/diseq_basic.R,
%   R/diseq_deterministic_adjustment.R, R/diseq_directional.R,
%   R/diseq_stochastic_adjustment.R, R/equilibrium_model.R
\name{scores}
\alias{scores}
\alias{scores,diseq_basic-method}
\alias{scores,diseq_deterministic_adjustment-method}
\alias{scores,diseq_directional-method}
\alias{scores,diseq_stochastic_adjustment-method}
\alias{scores,equilibrium_model-method}
\title{Likelihood scores.}
\usage{
scores(object, parameters)

\S4method{scores}{diseq_basic}(object, parameters)

\S4method{scores}{diseq_deterministic_adjustment}(object, parameters)

\S4method{scores}{diseq_directional}(object, parameters)

\S4method{scores}{diseq_stochastic_adjustment}(object, parameters)

\S4method{scores}{equilibrium_model}(object, parameters)
}
\arguments{
\item{object}{A model object.}

\item{parameters}{A vector with model parameters.}
}
\value{
The score matrix.
}
\description{
It calculates the gradient of the likelihood at the given parameter point for each
observation in the sample. It, therefore, returns an n x k matrix, where n denotes
the number of observations in the sample and k the number of estimated parameters.
There order of the parameters is the same as the one that is used in the summary
of the results.
}
\examples{
\donttest{
simulated_data <- simulate_model_data(
  "diseq_basic", 500, 3, # model type, observed entities, observed time points
  -0.9, 8.9, c(0.3, -0.2), c(-0.03, -0.01), # demand coefficients
  0.9, 4.2, c(0.03), c(-0.05, 0.02) # supply coefficients
)

# initialize the model
model <- new(
  "diseq_basic", # model type
  c("id", "date"), "Q", "P", # keys, quantity, and price variables
  "P + Xd1 + Xd2 + X1 + X2", "P + Xs1 + X1 + X2", # equation specifications
  simulated_data, # data
  correlated_shocks = TRUE # allow shocks to be correlated
)

# estimate the model object (by default the maximum optimization is using BFGS)
est <- estimate(model)

# Calculate the score matrix
scores <- scores(model, est@coef)
}
}
