% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmap.r
\name{cmap}
\alias{cmap}
\alias{cmap.disk.frame}
\alias{cmap_dfr}
\alias{cmap_dfr.disk.frame}
\alias{cimap}
\alias{cimap.disk.frame}
\alias{cimap_dfr}
\alias{cimap_dfr.disk.frame}
\alias{lazy}
\alias{lazy.disk.frame}
\alias{delayed}
\alias{clapply}
\title{Apply the same function to all chunks}
\usage{
cmap(.x, .f, ...)

\method{cmap}{disk.frame}(.x, .f, ...)

cmap_dfr(.x, .f, ..., .id = NULL)

\method{cmap_dfr}{disk.frame}(.x, .f, ..., .id = NULL, use.names = fill, fill = FALSE, idcol = NULL)

cimap(.x, .f, ...)

\method{cimap}{disk.frame}(
  .x,
  .f,
  outdir = NULL,
  keep = NULL,
  lazy = TRUE,
  overwrite = FALSE,
  compress = 50,
  ...
)

cimap_dfr(.x, .f, ..., .id = NULL)

\method{cimap_dfr}{disk.frame}(
  .x,
  .f,
  ...,
  .id = NULL,
  use.names = fill,
  fill = FALSE,
  idcol = NULL
)

lazy(.x, .f, ...)

\method{lazy}{disk.frame}(.x, .f, ...)

delayed(.x, .f, ...)

clapply(...)
}
\arguments{
\item{.x}{a disk.frame}

\item{.f}{a function to apply to each of the chunks}

\item{...}{Passed to `collect` and `write_disk.frame`}

\item{.id}{ignored}

\item{use.names}{for cmap_dfr's call to data.table::rbindlist. See data.table::rbindlist}

\item{fill}{for cmap_dfr's call to data.table::rbindlist. See data.table::rbindlist}

\item{idcol}{for cmap_dfr's call to data.table::rbindlist. See data.table::rbindlist}

\item{outdir}{the output directory}

\item{keep}{The columns to keep at source}

\item{lazy}{if TRUE then do this lazily}

\item{overwrite}{Whether to overwrite any files in the output directory}

\item{compress}{The compression setting. 0-100}
}
\description{
Apply the same function to all chunks

`cimap.disk.frame` accepts a two argument function where the first argument is a data.frame and the 
second is the chunk ID

`lazy` is convenience function to apply `.f` to every chunk

`delayed` is an alias for lazy and is consistent with the naming in Dask and Dagger.jl
}
\examples{
cars.df = as.disk.frame(cars)

# return the first row of each chunk lazily
# 
cars2 = cmap(cars.df, function(chunk) {
 chunk[,1]
})

collect(cars2)

# same as above but using purrr 
cars2 = cmap(cars.df, ~.x[1,])

collect(cars2)

# return the first row of each chunk eagerly as list
cmap(cars.df, ~.x[1,], lazy = FALSE)

# return the first row of each chunk eagerly as data.table/data.frame by row-binding
cmap_dfr(cars.df, ~.x[1,])

# lazy and delayed are just an aliases for cmap(..., lazy = TRUE)
collect(lazy(cars.df, ~.x[1,]))
collect(delayed(cars.df, ~.x[1,]))

# clean up cars.df
delete(cars.df)
}
