% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.morpho.R
\name{check.morpho}
\alias{check.morpho}
\title{Check a morphological matrix consistency levels.}
\usage{
check.morpho(
  matrix,
  orig.tree,
  parsimony = "fitch",
  first.tree = c(phangorn::dist.hamming, phangorn::NJ),
  distance = phangorn::RF.dist,
  ...,
  contrast.matrix,
  verbose = FALSE
)
}
\arguments{
\item{matrix}{A discrete morphological matrix.}

\item{orig.tree}{Optional, the input tree to measure the distance between the parsimony and the original tree.}

\item{parsimony}{Either the parsimony algorithm to be passed to \code{\link[phangorn]{optim.parsimony}} or a parsimony function that can take a \code{\link[phangorn]{phyDat}} object as an input (\code{default = "fitch"}).}

\item{first.tree}{A list of functions to generate the first most parsimonious tree (default = \code{c(\link[phangorn]{dist.hamming}, \link[phangorn]{NJ})}; see details).}

\item{distance}{Optional, if orig.tree is provided, the function to use for measuring distance between the trees (default = \code{link[phangorn]{RF.dist}}).}

\item{...}{Any additional arguments to be passed to the parsimony algorithm.}

\item{contrast.matrix}{An optional contrast matrix. By default, the function recognises any character state token as different apart from \code{?} that is treated as all characters.}

\item{verbose}{Whether to be verbose or not (\code{default = FALSE}).}
}
\value{
Returns the parsimony score (using \code{\link[phangorn]{parsimony}}), the consistency and retention indices (using \code{\link[phangorn]{CI}} and \code{\link[phangorn]{RI}}) from the most parsimonious tree obtained from the matrix.
Can also return the topological distance from the original tree if provided.
}
\description{
Performs a fast check of the phylogenetic signal in a morphological matrix using parsimony.
}
\details{
\itemize{
\item The \code{first.tree} argument must be a list of functions to be used in a cascade to transform the matrix (as a \code{\link[phangorn]{phyDat}} object) into a tree using the functions iteratively.
For example the default \code{c(\link[phangorn]{dist.hamming}, \link[phangorn]{NJ})} will apply the following to the matrix: \code{\link[phangorn]{NJ}(\link[phangorn]{dist.hamming}(matrix))}
}
}
\examples{
## Generating a random tree
random_tree <- rcoal(10)

## Generating a random matrix
random_matrix <- sim.morpho(random_tree, characters = 50, model = "ER",
     rates = c(rgamma, 1, 1))

## Checking the matrix scores
check.morpho(random_matrix, orig.tree = random_tree)

}
\seealso{
\code{\link{sim.morpho}}, \code{\link{get.contrast.matrix}}, \code{\link[phangorn]{optim.parsimony}}
}
\author{
Thomas Guillerme
}
