% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_global_scaling_params.R
\name{utils_global_scaling_params}
\alias{utils_global_scaling_params}
\title{Global Centering and Scaling Parameters of Time Series Lists}
\usage{
utils_global_scaling_params(tsl = NULL, f = NULL, ...)
}
\arguments{
\item{tsl}{(required, list) Time series list. Default: NULL}

\item{f}{(required, function) function \code{\link[=f_scale_global]{f_scale_global()}}. Default: NULL}

\item{...}{(optional, arguments of \code{f}) Optional arguments for the transformation function.}
}
\value{
list
}
\description{
Internal function to compute global scaling parameters (mean and standard deviation) for time series lists. Used within \code{\link[=tsl_transform]{tsl_transform()}} when the scaling function \code{\link[=f_scale_global]{f_scale_global()}} is used as input for the argument \code{f}.

Warning: this function removes exclusive columns from the data. See function \code{\link[=tsl_subset]{tsl_subset()}}.
}
\seealso{
Other tsl_processing_internal: 
\code{\link{utils_drop_geometry}()},
\code{\link{utils_optimize_loess}()},
\code{\link{utils_optimize_spline}()},
\code{\link{utils_rescale_vector}()}
}
\concept{tsl_processing_internal}
