% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_matrix_plot.R
\name{utils_matrix_plot}
\alias{utils_matrix_plot}
\title{Plot Distance or Cost Matrix and Least Cost Path}
\usage{
utils_matrix_plot(
  m = NULL,
  matrix_color = NULL,
  title = NULL,
  subtitle = NULL,
  xlab = NULL,
  ylab = NULL,
  text_cex = 1,
  path = NULL,
  path_width = 1,
  path_color = "black",
  diagonal_width = 1,
  diagonal_color = "white",
  guide = TRUE,
  subpanel = FALSE
)
}
\arguments{
\item{m}{(required, numeric matrix) distance or cost matrix generated by \code{\link[=psi_distance_matrix]{psi_distance_matrix()}} or \code{\link[=psi_cost_matrix]{psi_cost_matrix()}}, but any numeric matrix will work. Default: NULL}

\item{matrix_color}{(optional, character vector) vector of colors. Uses the palette "Zissou 1" by default. Default: NULL}

\item{title}{(optional, character string) plot title. By default, names of the sequences used to compute the matrix \code{m}. Default: NULL}

\item{subtitle}{(optional, character string) plot subtitle. Default: NULL}

\item{xlab}{(optional, character string) title of the x axis (matrix columns). By default, the name of one of the sequences used to compute the matrix \code{m}. Default: NULL}

\item{ylab}{(optional, character string) title of the y axis (matrix rows). By default, the name of one of the sequences used to compute the matrix \code{m}. Default: NULL}

\item{text_cex}{(optional, numeric) multiplicator of the text size for the plot labels and titles. Default: 1}

\item{path}{(optional, data frame) least cost path generated with \code{\link[=psi_cost_path]{psi_cost_path()}}. This data frame must have the attribute \verb{type == "cost_path}, and must have been computed from the same sequences used to compute the matrix \code{m}. Default: NULL.}

\item{path_width}{(optional, numeric) width of the least cost path. Default: 1}

\item{path_color}{(optional, character string) color of the least-cost path. Default: "black"}

\item{diagonal_width}{(optional, numeric) width of the diagonal. Set to 0 to remove the diagonal line. Default: 0.5}

\item{diagonal_color}{(optional, character string) color of the diagonal. Default: "white"}

\item{guide}{(optional, logical) if TRUE, a color guide for the matrix \code{m} is added by \code{\link[=utils_matrix_guide]{utils_matrix_guide()}}.}

\item{subpanel}{(optional, logical) internal argument used when generating the multi-panel plot produced by \code{\link[=distantia_dtw_plot]{distantia_dtw_plot()}}.}
}
\value{
plot
}
\description{
This function is a simplified version of \code{\link[fields:imagePlot]{fields::imagePlot()}}, by \href{https://dnychka.github.io/}{Douglas Nychka}. The original version is recommended in case more customization than the provided here is needed.
}
\examples{
#prepare time series list
tsl <- tsl_simulate(
  n = 2,
  independent = TRUE
)

#distance matrix between time series
dm <- psi_distance_matrix(
  x = tsl[[1]],
  y = tsl[[2]]
)

#cost matrix
cm <- psi_cost_matrix(
  dist_matrix = dm
  )

#least cost path
cp <- psi_cost_path(
  dist_matrix = dm,
  cost_matrix = cm
)

#plot cost matrix and least cost path
if(interactive()){
  utils_matrix_plot(
    m = cm,
    path = cp,
    guide = TRUE
  )
}
}
\seealso{
Other internal_plotting: 
\code{\link{color_continuous}()},
\code{\link{color_discrete}()},
\code{\link{utils_color_breaks}()},
\code{\link{utils_line_color}()},
\code{\link{utils_line_guide}()},
\code{\link{utils_matrix_guide}()}
}
\concept{internal_plotting}
