#' @title distantia: A Toolset for Time Series Dissimilarity Analysis
#'
#' @description
#' Fast C++ implementation of Dynamic Time Warping for time series dissimilarity analysis, with applications in environmental monitoring and sensor data analysis, climate science, signal processing and pattern recognition, and financial data analysis. Built upon the ideas presented in Benito and Birks (2020) <doi:doi.org/10.1111/ecog.04895>, provides tools for analyzing time series of varying lengths and structures, including irregular multivariate time series. Key features include individual variable contribution analysis, restricted permutation tests for statistical significance, and imputation of missing data via GAMs. Additionally, the package provides an ample set of tools to prepare and manage time series data.
#'
#' @docType package
#' @author Blas Benito <blasbenito@gmail.com>
#' @keywords internal
#' @importFrom Rcpp evalCpp
#' @useDynLib distantia
#' @name distantia-package
"_PACKAGE"
