% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distdichoigen.R
\name{distdichoigen}
\alias{distdichoigen}
\title{normal, skew-normal or gamma distributed data (immediate form)}
\usage{
distdichoigen(n1, m1, s1, n2, m2, s2, alpha = 1, cp = 0, tail = c("lower",
  "upper"), conf.level = 0.95, dist = c("normal", "sk_normal", "gamma"))
}
\arguments{
\item{n1}{A number specifying the number of observations in the exposed group.}

\item{m1}{A number specifying the mean of the exposed group.}

\item{s1}{A number specifying the standard deviation of the exposed group.}

\item{n2}{A number specifying the number of observations in the unexposed (reference) group.}

\item{m2}{A number specifying the mean of the unexposed (reference) group.}

\item{s2}{A number specifying the standard deviation of the unexposed (reference) group.}

\item{alpha}{A numeric value specifying further parameter of the skew normal / gamma distribution.}

\item{cp}{A numeric value specifying the cut point under which the distributional proportions are computed.}

\item{tail}{A character string specifying the tail of the distribution in which the proportions are computed,
must be either 'lower' (default) or 'upper'.}

\item{conf.level}{Confidence level of the interval.}

\item{dist}{A character string specifying the distribution, must be either 'normal' (default), 'sk_normal or 'gamma'.}
}
\value{
A list with class 'distdicho' containing the following components:
\item{data.name}{The names of the data.}
\item{arguments}{A list with the specified arguments.}
\item{parameter}{The mean, standard error and number of observations for both groups.}
\item{prop}{The estimated proportions below / above the cut point for both groups.}
\item{dist.estimates}{The difference in proportions, risk ratio and odds ratio of the groups.}
\item{se}{The estimated standard error of the difference in proportions, the risk ratio and the odds ratio.}
\item{ci}{The confidence intervals of the difference in proportions, the risk ratio and the odds ratio.}
\item{method}{A character string indicating the used method.}
\item{ttest}{A list containing the results of a t-test.}
}
\description{
Immediate form of the distributional method for dichotomising normal, skew normal or gamma distributed data
(based on Sauzet et al. 2015).
}
\details{
distdichoigen takes no data, but the number of observations as well as the mean and standard deviations of both groups.
It first returns the results of a two-group unpaired t-test.
Followed by the distributional estimates and their standard errors (see Sauzet et al. 2014 and Peacock et al. 2012)
for a difference in proportions, risk ratio and odds ratio. It also provides the distributional confidence intervals for the statistics estimated.
If a skew normal (dist = 'sk_normal') or gamma (dist = 'gamma') distribution is assumed, a third parameter alpha needs to be specified.
For (dist = 'sk_normal') alpha is described in \code{\link[sn]{psn}}. 
For dist = 'gamma' alpha is the shape as described in \code{\link[stats]{pgamma}}.
}
\examples{
# Immediate form of sk_distdicho
distdichoigen(n1 = 75, m1 = 3250, s1 = 450, n2 = 110, m2 = 2950, s2 = 475,
               cp = 2500, tail = 'lower', alpha = -2.3, dist = 'sk_normal')

           
}
\references{
Peacock J.L., Sauzet O., Ewings S.M., Kerry S.M. Dichotomising continuous data while retaining statistical power using a distributional approach.  Statist. Med; 2012; 26:3089-3103.
Sauzet, O., Peacock, J. L. Estimating dichotomised outcomes in two groups with unequal variances: a distributional approach.  Statist. Med; 2014 33 4547-4559 ;DOI: 10.1002/sim.6255.
Sauzet, O., Ofuya, M., Peacock, J. L. Dichotomisation using a distributional approach when the outcome is skewed BMC Medical Research Methodology 2015, 15:40; doi:10.1186/s12874-015-0028-8.
Peacock, J.L., Bland, J.M., Anderson, H.R.: Preterm delivery: effects of socioeconomic factors, psychological stress, smoking, alcohol, and caffeine. BMJ 311(7004), 531-535 (1995).
}
\seealso{
\code{\link[distdichoR]{distdicho}}, \code{\link[distdichoR]{distdichoi}}, \code{\link[distdichoR]{distdichogen}}, \code{\link[distdichoR]{regdistdicho}}
}
