\name{Binom-class}
\docType{class}
\alias{Binom-class}
\alias{Binom}
\alias{initialize,Binom-method}

\title{Class "Binom" }
\description{The binomial distribution with \code{size} \eqn{= n}, by default \eqn{=1}, and
  \code{prob} \eqn{= p}, by default \eqn{=0.5}, has density
  \deqn{p(x) = {n \choose x} {p}^{x} {(1-p)}^{n-x}}{
    p(x) = choose(n,x) p^x (1-p)^(n-x)}
  for \eqn{x = 0, \ldots, n}.

  C.f.\code{\link[stats:Binomial]{rbinom}}
}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{Binom(prob, size)}.
This object is a binomial distribution. 
}
\section{Slots}{
  \describe{
    \item{\code{img}:}{Object of class \code{"Naturals"}: The space of the image of this
     distribution has got dimension 1 and the name "Natural Space". }
    \item{\code{param}:}{Object of class \code{"BinomParameter"}: the parameter of this distribution (\code{prob}, \code{size}),
     declared at its instantiation }
    \item{\code{r}:}{Object of class \code{"function"}: generates random numbers (calls function \code{rbinom}) }
    \item{\code{d}:}{Object of class \code{"function"}: density function (calls function \code{dbinom}) }
    \item{\code{p}:}{Object of class \code{"function"}: cumulative function (calls function \code{pbinom}) }
    \item{\code{q}:}{Object of class \code{"function"}: inverse of the cumulative function (calls function \code{qbinom}).
    The quantile is defined as the smallest value x such that F(x) >= p, where F is the cumulative function. }
    \item{\code{support}:}{Object of class \code{"numeric"}: a (sorted) vector containing the support of the discrete
    density function}
  }
}
\section{Extends}{
Class \code{"DiscreteDistribution"}, directly.\cr
Class \code{"UnivariateDistribution"}, by class \code{"DiscreteDistribution"}.\cr
Class \code{"Distribution"}, by class \code{"DiscreteDistribution"}.
}
\section{Methods}{
  \describe{
    \item{+}{\code{signature(e1 = "Binom", e2 = "Binom")}: For two binomial distributions with equal probabilities
    the exact convolution formula is implemented thereby improving the general numerical approximation.}
    \item{initialize}{\code{signature(.Object = "Binom")}: initialize method }
    \item{prob}{\code{signature(object = "Binom")}: returns the slot \code{prob} of the parameter of the distribution }
    \item{prob<-}{\code{signature(object = "Binom")}: modifies the slot \code{prob} of the parameter of the distribution }
    \item{size}{\code{signature(object = "Binom")}: returns the slot \code{size} of the parameter of the distribution }
    \item{size<-}{\code{signature(object = "Binom")}: modifies the slot \code{size} of the parameter of the distribution }
  }
}


\author{
  Thomas Stabla \email{statho3@web.de},\cr 
  Florian Camphausen \email{fcampi@gmx.de},\cr
  Peter Ruckdeschel \email{Peter.Ruckdeschel@uni-bayreuth.de},\cr 
  Matthias Kohl \email{Matthias.Kohl@stamats.de}
  }


\seealso{
\code{\link{BinomParameter-class}}
\code{\link{DiscreteDistribution-class}}
\code{\link{Naturals-class}}
\code{\link[stats:Binomial]{rbinom}}
}
\examples{
B=Binom(prob=0.5,size=1) # B is a binomial distribution with prob=0.5 and size=1.
r(B)(1) # # one random number generated from this distribution, e.g. 1
d(B)(1) # Density of this distribution is  0.5 for x=1.
p(B)(0.4) # Probability that x<0.4 is 0.5.
q(B)(.1) # x=0 is the smallest value x such that p(B)(x)>=0.1.
size(B) # size of this distribution is 1.
size(B)=2 # size of this distribution is now 2.
C=Binom(prob=0.5,size=1) # C is a binomial distribution with prob=0.5 and size=1.
D=Binom(prob=0.6,size=1) # D is a binomial distribution with prob=0.6 and size=1.
E=B+C # E is a binomial distribution with prob=0.5 and size=3.
F=B+D # F is an object of class DiscreteDistribution.
}
\keyword{distribution}
