% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wrapper_VectorDistribution.R
\name{VectorDistribution}
\alias{VectorDistribution}
\title{Vectorise Distributions}
\value{
Returns an R6 object of class VectorDistribution.
}
\description{
A wrapper for creating a vector of distributions.
}
\details{
A vector of distributions has the following relationship
\deqn{f_V(X1 = x1,...,XN = xN) = f_{X1}(x1), ..., f_{XN}(xn)}{f_V(X1 = x1,...,XN = xN) = f_X1(x1), ..., f_XN(xn)}
\deqn{F_V(X1 = x1,...,XN = xN) = F_{X1}(x1), ..., F_{XN}(xn)}{F_V(X1 = x1,...,XN = xN) = F_X1(x1), ..., F_XN(xn)}
where \eqn{f_V}/\eqn{F_V} is the pdf/cdf of the vector of distributions \eqn{V} and \eqn{X1,...,XN} are distributions.
}
\section{Constructor}{
 VectorDistribution$new(distlist, name = NULL, short_name = NULL, description = NULL)
}

\section{Constructor Arguments}{

\tabular{lll}{
\strong{Argument} \tab \strong{Type} \tab \strong{Details} \cr
\code{distlist} \tab list \tab List of distributions. \cr
\code{name} \tab list \tab Optional new name for distribution. \cr
\code{short_name} \tab list \tab Optional new short_name for distribution. \cr
\code{description} \tab list \tab Optional new description for distribution. \cr
}
}

\section{Public Variables}{

 \tabular{ll}{
  \strong{Variable} \tab \strong{Return} \cr
  \code{name} \tab Name of distribution. \cr
  \code{short_name} \tab Id of distribution. \cr
  \code{description} \tab Brief description of distribution. \cr
  \code{package} \tab The package d/p/q/r are implemented in.
 }
}

\section{Public Methods}{

 \tabular{ll}{
  \strong{Accessor Methods} \tab \strong{Link} \cr
  \code{wrappedModels(model = NULL)} \tab \code{\link{wrappedModels}} \cr
  \code{decorators()} \tab \code{\link{decorators}} \cr
  \code{traits()} \tab \code{\link{traits}} \cr
  \code{valueSupport()} \tab \code{\link{valueSupport}} \cr
  \code{variateForm()} \tab \code{\link{variateForm}} \cr
  \code{type()} \tab \code{\link{type}} \cr
  \code{properties()} \tab \code{\link{properties}} \cr
  \code{support()} \tab \code{\link{support}} \cr
  \code{symmetry()} \tab \code{\link{symmetry}} \cr
  \code{sup()}  \tab \code{\link{sup}} \cr
  \code{inf()} \tab \code{\link{inf}} \cr
  \code{dmax()}  \tab \code{\link{dmax}} \cr
  \code{dmin()} \tab \code{\link{dmin}} \cr
  \code{skewnessType()} \tab \code{\link{skewnessType}} \cr
  \code{kurtosisType()} \tab \code{\link{kurtosisType}} \cr
  \tab \cr \tab \cr \tab \cr
  \strong{d/p/q/r Methods} \tab \strong{Link} \cr
  \code{pdf(x1, ..., log = FALSE, simplify = TRUE)} \tab \code{\link{pdf}} \cr
  \code{cdf(x1, ..., lower.tail = TRUE, log.p = FALSE, simplify = TRUE)} \tab \code{\link{cdf}}\cr
  \code{quantile(p, ..., lower.tail = TRUE, log.p = FALSE, simplify = TRUE)} \tab \code{\link{quantile.Distribution}} \cr
  \code{rand(n, simplify = TRUE)} \tab \code{\link{rand}} \cr
  \tab \cr \tab \cr \tab \cr
  \strong{Statistical Methods} \tab \strong{Link} \cr
  \code{prec()} \tab \code{\link{prec}} \cr
  \code{stdev()} \tab \code{\link{stdev}}\cr
  \code{median()} \tab \code{\link{median.Distribution}} \cr
  \code{iqr()} \tab \code{\link{iqr}} \cr
  \code{cor()} \tab \code{\link{cor}} \cr
  \tab \cr \tab \cr \tab \cr
  \strong{Parameter Methods} \tab \strong{Link} \cr
  \code{parameters(id)} \tab \code{\link{parameters}} \cr
  \code{getParameterValue(id, error = "warn")}  \tab \code{\link{getParameterValue}} \cr
  \code{setParameterValue(..., lst = NULL, error = "warn")} \tab \code{\link{setParameterValue}} \cr
  \tab \cr \tab \cr \tab \cr
  \strong{Validation Methods} \tab \strong{Link} \cr
  \code{liesInSupport(x, all = TRUE, bound = FALSE)} \tab \code{\link{liesInSupport}} \cr
  \code{liesInType(x, all = TRUE, bound = FALSE)} \tab \code{\link{liesInType}} \cr
  \tab \cr \tab \cr \tab \cr
  \strong{Representation Methods} \tab \strong{Link} \cr
  \code{strprint()} \tab \code{\link{strprint}} \cr
  \code{print()} \tab \code{\link[base]{print}} \cr
  \code{summary(full = T)} \tab \code{\link{summary.Distribution}} \cr
  \code{plot()} \tab Coming Soon. \cr
  \code{qqplot()} \tab Coming Soon. \cr
  }
}

\examples{
vecBin <- VectorDistribution$new(list(Binomial$new(prob = 0.5,
                           size = 10), Normal$new(mean = 15)))
vecBin$pdf(x1 = 2, x2 =3)
vecBin$cdf(1:5, 12:16)
vecBin$quantile(c(0.1,0.2),c(0.3,0.4))
vecBin$rand(10)

}
\seealso{
\code{\link{listWrappers}}
}
