% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distribution.R
\name{pdf}
\alias{pdf}
\title{Probability Density/Mass Function}
\usage{
pdf(object, x1, ..., log = FALSE, simplify = TRUE)
}
\arguments{
\item{object}{Distribution.}

\item{x1}{vector of numerics to evaluate function at.}

\item{...}{additional arguments.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{simplify}{if TRUE (default) returns results in simplest form (vector or data.table) otherwise as data.table.}
}
\value{
Probability density function evaluated at given points as either a numeric if \code{simplify} is TRUE
or as a data.table.
}
\description{
Returns the probability density/mass function for continuous/discrete (or mixture)
distributions evaluated at a given point.
}
\details{
For discrete distributions the probability mass function (pmf) is returned, defined as
 \deqn{p_X(x) = P(X = x)}
 for continuous distributions the probability density function (pdf), \eqn{f_X}, is returned
 \deqn{f_X(x) = P(x < X \le x + dx)}
 for some infinitesimally small \eqn{dx}.

If available a pdf will be returned without warning using an analytic expression. Otherwise,
if the distribution has not been decorated with \code{FunctionImputation}, \code{NULL} is returned.
To impute the pdf, use \code{decorate(distribution, FunctionImputation)}, this will provide a numeric
calculation for the pdf with warning.

Additional named arguments can be passed, which are required for composite distributions such as
\code{\link{ProductDistribution}} and \code{\link{ArrayDistribution}}.
}
\section{R6 Usage}{
 $pdf(x1, ..., log = FALSE, simplify = TRUE)
}

\seealso{
\code{\link{cdf}}, \code{\link{quantile}}, \code{\link{rand}} for other statistical functions.
\code{\link{FunctionImputation}}, \code{\link{decorate}} for imputing missing functions.
}
