% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wrapper_VectorDistribution.R
\name{VectorDistribution}
\alias{VectorDistribution}
\title{Vectorise Distributions}
\value{
Returns an R6 object of class VectorDistribution.
}
\description{
A wrapper for creating a vector of distributions.
}
\details{
A vector distribution is intented to vectorize distributions more efficiently than storing
a list of distributions. To improve speed and reduce memory usage, distributions are only constructed
when methods (e.g. d/p/q/r) are called. Whilst it is recommended to first extract distributions
using \code{[} before querying them for results, all common methods are available in
\code{VectorDistribution} as they are wrapped in \code{apply}.
}
\section{Constructor}{
 VectorDistribution$new(distlist = NULL, distribution = NULL, params = NULL,
name = NULL, short_name = NULL, description = NULL, decorators = NULL)
}

\section{Constructor Arguments}{

\tabular{lll}{
\strong{Argument} \tab \strong{Type} \tab \strong{Details} \cr
\code{distlist} \tab list \tab List of distributions. \cr
\code{distribution} \tab character \tab Distribution to wrap. \cr
\code{params} \tab a R object \tab Either list of parameters or matrix-type frame, see examples. \cr
\code{shared_params} \tab a R object \tab Either list of shared parameters or matrix-type frame, see examples. \cr
\code{name} \tab list \tab Optional new name for distribution. \cr
\code{short_name} \tab list \tab Optional new short_name for distribution. \cr
\code{description} \tab list \tab Optional new description for distribution. \cr
\code{decorators} \tab list \tab Decorators to pass to wrapped distributions on construction. \cr
}
}

\section{Constructor Details}{
 A vector distribution can either be constructed by a list of
distributions passed to \code{distlist} or by passing the name of one or more distributions
implemented in distr6 to \code{distribution}, as well as a list or table of parameters to \code{params}.
The former case provides more flexibility in the ability to use wrapped distributions
but the latter is vastly faster for distributions of class \code{SDistribution} or custom distributions.
The \code{shared_params} parameter decreases memory usage and improves speed by storing any parameters
shared between distributions only once (instead of repeated in a list).
}

\section{Public Variables}{

\tabular{ll}{
\strong{Variable} \tab \strong{Return} \cr
\code{name} \tab Name of distribution. \cr
\code{short_name} \tab Id of distribution. \cr
\code{description} \tab Brief description of distribution. \cr
\code{package} \tab The package d/p/q/r are implemented in.
}
}

\section{Public Methods}{

\tabular{ll}{
\strong{Accessor Methods} \tab \strong{Link} \cr
\code{wrappedModels(model = NULL)} \tab \code{\link{wrappedModels}} \cr
\code{decorators} \tab \code{\link{decorators}} \cr
\code{traits} \tab \code{\link{traits}} \cr
\code{valueSupport} \tab \code{\link{valueSupport}} \cr
\code{variateForm} \tab \code{\link{variateForm}} \cr
\code{type} \tab \code{\link{type}} \cr
\code{properties} \tab \code{\link{properties}} \cr
\code{support} \tab \code{\link{support}} \cr
\code{symmetry} \tab \code{\link{symmetry}} \cr
\code{sup}  \tab \code{\link{sup}} \cr
\code{inf} \tab \code{\link{inf}} \cr
\code{dmax}  \tab \code{\link{dmax}} \cr
\code{dmin} \tab \code{\link{dmin}} \cr
\code{skewnessType} \tab \code{\link{skewnessType}} \cr
\code{kurtosisType} \tab \code{\link{kurtosisType}} \cr
\tab \cr \tab \cr \tab \cr
\strong{d/p/q/r Methods} \tab \strong{Link} \cr
\code{pdf(x1, ..., log = FALSE, simplify = TRUE)} \tab \code{\link{pdf}} \cr
\code{cdf(x1, ..., lower.tail = TRUE, log.p = FALSE, simplify = TRUE)} \tab \code{\link{cdf}}\cr
\code{quantile(p, ..., lower.tail = TRUE, log.p = FALSE, simplify = TRUE)} \tab \code{\link{quantile.Distribution}} \cr
\code{rand(n, simplify = TRUE)} \tab \code{\link{rand}} \cr
\tab \cr \tab \cr \tab \cr
\strong{Statistical Methods} \tab \strong{Link} \cr
\code{prec()} \tab \code{\link{prec}} \cr
\code{stdev()} \tab \code{\link{stdev}}\cr
\code{median()} \tab \code{\link{median.Distribution}} \cr
\code{iqr()} \tab \code{\link{iqr}} \cr
\code{cor()} \tab \code{\link{cor}} \cr
\tab \cr \tab \cr \tab \cr
\strong{Parameter Methods} \tab \strong{Link} \cr
\code{parameters(id)} \tab \code{\link{parameters}} \cr
\code{getParameterValue(id, error = "warn")}  \tab \code{\link{getParameterValue}} \cr
\code{setParameterValue(..., lst = NULL, error = "warn")} \tab \code{\link{setParameterValue}} \cr
\tab \cr \tab \cr \tab \cr
\strong{Validation Methods} \tab \strong{Link} \cr
\code{liesInSupport(x, all = TRUE, bound = FALSE)} \tab \code{\link{liesInSupport}} \cr
\code{liesInType(x, all = TRUE, bound = FALSE)} \tab \code{\link{liesInType}} \cr
\tab \cr \tab \cr \tab \cr
\strong{Representation Methods} \tab \strong{Link} \cr
\code{strprint(n = 2)} \tab \code{\link{strprint}} \cr
\code{print(n = 2)} \tab \code{\link[base]{print}} \cr
\code{summary(full = T)} \tab \code{\link{summary.Distribution}} \cr
}
}

\examples{
# not run to save time
\dontrun{
vecDist <- VectorDistribution$new(list(Binomial$new(prob = 0.5,
                           size = 10), Normal$new(mean = 15)))
vecDist$pdf(x1 = 2, x2 =3)
# Equivalently
vecDist[1]$pdf(2); vecDist[2]$pdf(3)
# Or to evaluate every distribution at the same point
vecDist$pdf(1)

# Same wrapping for statistical functions
vecDist$mean()
c(vecDist[1]$mean(), vecDist[2]$mean())
vecDist$entropy()
c(vecDist[1]$entropy(), vecDist[2]$entropy())

vecDist$cdf(1:5, 12:16)
vecDist$rand(10)

vecBin = VectorDistribution$new(distribution = "Binomial",
       params = list(list(prob = 0.1, size = 2),
                   list(prob = 0.6, size = 4),
                   list(prob = 0.2, size = 6)))
vecBin$pdf(x1=1,x2=2,x3=3)
vecBin$cdf(x1=1,x2=2,x3=3)
vecBin$rand(10)

#Equivalently
vecBin = VectorDistribution$new(distribution = "Binomial",
       params = data.table::data.table(prob = c(0.1,0.6,0.2), size = c(2,4,6)))
vecBin$pdf(x1=1,x2=2,x3=3)
vecBin$cdf(x1=1,x2=2,x3=3)
vecBin$rand(10)

# sharedparams is very useful for vectorized custom distributions
shared_params = list(name = "A Distribution", short_name = "Dist", type = Reals$new())
params = list(list(pdf = function(x) return(1)), list(pdf = function(x) return(2)))
vecdist = VectorDistribution$new(distribution = "Distribution", params = params,
                                   shared_params = shared_params)
vecdist$pdf(1)
}

}
\seealso{
\code{\link{listWrappers}} and \code{\link{ProductDistribution}}
}
