% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParameterSetCollection.R
\name{ParameterSetCollection}
\alias{ParameterSetCollection}
\title{Parameter Set Collections for Wrapped Distributions}
\description{
ParameterSetCollection is used to combine multiple \link{ParameterSet}s in wrapped
distributions. Generally only need to be constructed internally.
}
\examples{

## ------------------------------------------------
## Method `ParameterSetCollection$new`
## ------------------------------------------------

b = Binomial$new()
g = Geometric$new()
ParameterSetCollection$new(Binom1 = b$parameters(),
                           Binom2 = b$parameters(),
                           Geom = g$parameters())

ParameterSetCollection$new(lst = list(Binom1 = b$parameters(),
                                      Binom2 = b$parameters(),
                                      Geom = g$parameters()))

## ------------------------------------------------
## Method `ParameterSetCollection$getParameterValue`
## ------------------------------------------------

psc <- ParameterSetCollection$new(Binom1 = Binomial$new()$parameters(),
                                  Binom2 = Binomial$new()$parameters(),
                                  Geom = Geometric$new()$parameters())
psc$getParameterValue("Binom1_prob")
psc$getParameterValue("prob")

## ------------------------------------------------
## Method `ParameterSetCollection$getParameterSupport`
## ------------------------------------------------

b <- Binomial$new()
g <- Geometric$new()
psc <- ParameterSetCollection$new(Binom1 = b$parameters(),
                                  Binom2 = b$parameters(),
                                  Geom = g$parameters())
psc$getParameterSupport("Binom1_prob")

## ------------------------------------------------
## Method `ParameterSetCollection$setParameterValue`
## ------------------------------------------------

b <- Binomial$new()
g <- Geometric$new()
psc <- ParameterSetCollection$new(Binom1 = b$parameters(),
                                  Binom2 = b$parameters(),
                                  Geom = g$parameters())
psc$getParameterValue("Binom1_prob")
b$getParameterValue("prob")
psc$setParameterValue(Binom1_prob = 0.4)
# both updated
psc$getParameterValue("Binom1_prob")
b$getParameterValue("prob")

g$setParameterValue(prob = 0.1)
# both updated
psc$getParameterValue("Geom_prob")
g$getParameterValue("prob")

## ------------------------------------------------
## Method `ParameterSetCollection$merge`
## ------------------------------------------------

b <- Binomial$new()
g <- Geometric$new()
psc <- ParameterSetCollection$new(Binom = b$parameters())
psc2 <- ParameterSetCollection$new(Geom = g$parameters())
psc$merge(psc2)$parameters()

}
\section{Super class}{
\code{\link[distr6:ParameterSet]{distr6::ParameterSet}} -> \code{ParameterSetCollection}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{deps}}{Returns \link{ParameterSet} dependencies table.}

\item{\code{parameterSets}}{Returns \link{ParameterSet}s in collection.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ParameterSetCollection$new()}}
\item \href{#method-print}{\code{ParameterSetCollection$print()}}
\item \href{#method-parameters}{\code{ParameterSetCollection$parameters()}}
\item \href{#method-getParameterValue}{\code{ParameterSetCollection$getParameterValue()}}
\item \href{#method-getParameterSupport}{\code{ParameterSetCollection$getParameterSupport()}}
\item \href{#method-setParameterValue}{\code{ParameterSetCollection$setParameterValue()}}
\item \href{#method-merge}{\code{ParameterSetCollection$merge()}}
\item \href{#method-addDeps}{\code{ParameterSetCollection$addDeps()}}
\item \href{#method-values}{\code{ParameterSetCollection$values()}}
\item \href{#method-clone}{\code{ParameterSetCollection$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="ParameterSet" data-id="addChecks">}\href{../../distr6/html/ParameterSet.html#method-addChecks}{\code{distr6::ParameterSet$addChecks()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="ParameterSet" data-id="addTrafos">}\href{../../distr6/html/ParameterSet.html#method-addTrafos}{\code{distr6::ParameterSet$addTrafos()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParameterSetCollection$new(..., lst = NULL, .checks = NULL, .supports = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\verb{([ParameterSet])}\cr
\link{ParameterSet}s to combine into a collection. Should be supplied as named arguments
where the names are unique and correspond to references for the distributions.}

\item{\code{lst}}{\code{(list())}\cr
Alternative constructor by supplying a named list of \link{ParameterSet}s.}

\item{\code{.checks}}{Used internally.}

\item{\code{.supports}}{Used internally.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{b = Binomial$new()
g = Geometric$new()
ParameterSetCollection$new(Binom1 = b$parameters(),
                           Binom2 = b$parameters(),
                           Geom = g$parameters())

ParameterSetCollection$new(lst = list(Binom1 = b$parameters(),
                                      Binom2 = b$parameters(),
                                      Geom = g$parameters()))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints the \link{ParameterSetCollection}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParameterSetCollection$print(hide_cols = c("settable"), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hide_cols}}{\code{(character())}\cr
Names of columns in the \link{ParameterSet} to hide whilst printing.}

\item{\code{...}}{\code{ANY} \cr
Additional arguments, currently unused.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-parameters"></a>}}
\if{latex}{\out{\hypertarget{method-parameters}{}}}
\subsection{Method \code{parameters()}}{
Returns the full parameter details for the supplied parameter, or returns \code{self}
if \code{id} is \code{NULL} or unmatched.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParameterSetCollection$parameters(id = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character()} \cr
id of parameter to return.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getParameterValue"></a>}}
\if{latex}{\out{\hypertarget{method-getParameterValue}{}}}
\subsection{Method \code{getParameterValue()}}{
Returns the value of the supplied parameter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParameterSetCollection$getParameterValue(id, error = "warn")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{(character(1))}
To return the parameter for a specific distribution, use the parameter ID with the
distribution name prefix, otherwise to return the parameter for all distributions omit
the prefix. See examples.}

\item{\code{error}}{\code{(character(1))} \cr
If \code{"warn"} then returns a warning on error, otherwise breaks if \code{"stop"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{psc <- ParameterSetCollection$new(Binom1 = Binomial$new()$parameters(),
                                  Binom2 = Binomial$new()$parameters(),
                                  Geom = Geometric$new()$parameters())
psc$getParameterValue("Binom1_prob")
psc$getParameterValue("prob")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getParameterSupport"></a>}}
\if{latex}{\out{\hypertarget{method-getParameterSupport}{}}}
\subsection{Method \code{getParameterSupport()}}{
Returns the support of the supplied parameter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParameterSetCollection$getParameterSupport(id, error = "warn")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character()} \cr
id of parameter support to return.}

\item{\code{error}}{\code{(character(1))} \cr
If \code{"warn"} then returns a warning on error, otherwise breaks if \code{"stop"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link[set6:Set]{set6::Set} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{b <- Binomial$new()
g <- Geometric$new()
psc <- ParameterSetCollection$new(Binom1 = b$parameters(),
                                  Binom2 = b$parameters(),
                                  Geom = g$parameters())
psc$getParameterSupport("Binom1_prob")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setParameterValue"></a>}}
\if{latex}{\out{\hypertarget{method-setParameterValue}{}}}
\subsection{Method \code{setParameterValue()}}{
Sets the value(s) of the given parameter(s). Because of R6 reference semantics
this also updates the \link{ParameterSet} of the wrapped distibution, and vice versa.
See examples.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParameterSetCollection$setParameterValue(..., lst = NULL, error = "warn")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{ANY} \cr
Named arguments of parameters to set values for. See examples.}

\item{\code{lst}}{\code{(list(1))} \cr
Alternative argument for passing parameters. List names should be parameter names and list values
are the new values to set.}

\item{\code{error}}{\code{(character(1))} \cr
If \code{"warn"} then returns a warning on error, otherwise breaks if \code{"stop"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{b <- Binomial$new()
g <- Geometric$new()
psc <- ParameterSetCollection$new(Binom1 = b$parameters(),
                                  Binom2 = b$parameters(),
                                  Geom = g$parameters())
psc$getParameterValue("Binom1_prob")
b$getParameterValue("prob")
psc$setParameterValue(Binom1_prob = 0.4)
# both updated
psc$getParameterValue("Binom1_prob")
b$getParameterValue("prob")

g$setParameterValue(prob = 0.1)
# both updated
psc$getParameterValue("Geom_prob")
g$getParameterValue("prob")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-merge"></a>}}
\if{latex}{\out{\hypertarget{method-merge}{}}}
\subsection{Method \code{merge()}}{
Merges other \link{ParameterSetCollection}s into \code{self}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParameterSetCollection$merge(..., lst = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\verb{([ParameterSetCollection]s)}}

\item{\code{lst}}{\code{(list(1))} \cr
Alternative argument for passing parameters. List names should be parameter names and list values
are the new values to set.}

\item{\code{`lst`}}{\code{(list())} \cr
Alternative method of passing a list of \link{ParameterSetCollection}s.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{b <- Binomial$new()
g <- Geometric$new()
psc <- ParameterSetCollection$new(Binom = b$parameters())
psc2 <- ParameterSetCollection$new(Geom = g$parameters())
psc$merge(psc2)$parameters()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addDeps"></a>}}
\if{latex}{\out{\hypertarget{method-addDeps}{}}}
\subsection{Method \code{addDeps()}}{
Dependencies should be added to internal \link{ParameterSet}s.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParameterSetCollection$addDeps(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{ANY} \cr Ignored.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-values"></a>}}
\if{latex}{\out{\hypertarget{method-values}{}}}
\subsection{Method \code{values()}}{
Returns parameter set values as a named list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParameterSetCollection$values(settable = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{settable}}{\code{(logical(1))}\cr
If \code{TRUE} (default) only returns values of settable parameters, otherwise returns all.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParameterSetCollection$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
