% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_vectordistribution.R
\name{plot.VectorDistribution}
\alias{plot.VectorDistribution}
\title{Plotting Distribution Functions for a VectorDistribution}
\usage{
\method{plot}{VectorDistribution}(x, fun = "pdf", topn, ind, cols, ...)
}
\arguments{
\item{x}{\link{VectorDistribution}.}

\item{fun}{function to plot, one of: "pdf","cdf","quantile", "survival", "hazard", "cumhazard".}

\item{topn}{\code{integer}. First n distributions in the \link{VectorDistribution} to plot.}

\item{ind}{\code{integer}. Indices of the distributions in the \link{VectorDistribution} to plot. If given
then \code{topn} is ignored.}

\item{cols}{\code{character}. Vector of colours for plotting the curves. If missing \code{1:9} are used.}

\item{...}{Other parameters passed to \link{plot.Distribution}.}
}
\description{
Helper function to more easily plot distributions inside a \link{VectorDistribution}.
}
\details{
If \code{topn} and \code{ind} are both missing then all distributions are plotted if there are 10 or less
in the vector, otherwise the function will error.
}
\examples{
\dontrun{
# Plot pdf of Normal distribution
vd <- VectorDistribution$new(list(Normal$new(), Normal$new(mean = 2)))
plot(vd)
plot(vd, fun = "surv")
plot(vd, fun = "quantile", ylim = c(-4, 4), col = c("blue", "purple"))
}
}
\seealso{
\link{plot.Distribution}
}
