##########################################################
### a new central distribution  in a location scale model
##########################################################

require(distrMod)
options("newDevice"=TRUE)

my3d <- AbscontDistribution( d = function(x) exp(-abs(x)^3), withS = TRUE)
plot(my3d)
## in a location scale model
scl.true <- 2; loc.true <- 3
my3dF <- L2LocationScaleFamily(loc = loc.true,
                               scale = scl.true,
                               name = "my3dF",
                               centraldistribution = my3d)

plot(my3dF)

### generate some data out of the model
x <- r(my3dF)(40)

### evaluate the MLE:
mledistrMod <- MLEstimator(x,my3dF)

#some profiling
par(mfrow=c(1,2))
plot(profile(mledistrMod))

# a confidence interval
confint(mledistrMod)

#A[n] asymptotic (CLT-based) confidence interval:
#         2.5 %   97.5 %
#loc   2.785576 3.391666
#scale 1.398247 2.007662
#Type of estimator: Maximum likelihood estimate
#samplesize:   40
#Call by which estimate was produced:
#MLEstimator(x = x, ParamFamily = my3dF)

(mde.kolm <- MDEstimator(x = x, ParamFamily = my3dF))

#Evaluations of Minimum Kolmogorov distance estimate:
#----------------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = x, ParamFamily = my3dF)
#samplesize:   40
#estimate:
#     loc    scale
#3.110172 1.857230
#Criterion:
#Kolmogorov distance
#         0.05978152

(mde.CvM <- MDEstimator(x = x, ParamFamily = my3dF, distance = CvMDist))

#Evaluations of Minimum CvM distance estimate:
#---------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = x, ParamFamily = my3dF, distance = CvMDist)
#samplesize:   40
#estimate:
#     loc    scale
#3.124343 1.817609
#Criterion:
#CvM distance
#  0.02527883

asvar(mde.CvM) <- distrMod:::.CvMMDCovariance(my3dF, 
                  param = ParamFamParameter(main= estimate(MDE)),
                  expon = 2, withplot = TRUE)
# a confidence interval
confint(mde.CvM)

#A[n] asymptotic (CLT-based) confidence interval:
#          2.5 %   97.5 %
#loc   1.9488691 4.299817
#scale 0.9260041 2.709214
#Type of estimator: Minimum CvM distance estimate
#samplesize:   40
#Call by which estimate was produced:
#MDEstimator(x = x, ParamFamily = my3dF, distance = CvMDist)
