% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HyperGeometric.R
\name{random.HyperGeometric}
\alias{random.HyperGeometric}
\title{Draw a random sample from a HyperGeometric distribution}
\usage{
\method{random}{HyperGeometric}(d, n = 1L, ...)
}
\arguments{
\item{d}{A \code{HyperGeometric} object created by a call to \code{\link[=HyperGeometric]{HyperGeometric()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
An integer vector of length \code{n}.
}
\description{
Please see the documentation of \code{\link[=HyperGeometric]{HyperGeometric()}} for some properties
of the HyperGeometric distribution, as well as extensive examples
showing to how calculate p-values and confidence intervals.
}
\examples{

set.seed(27)

X <- HyperGeometric(4, 5, 8)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)
}
\seealso{
Other HyperGeometric distribution: \code{\link{cdf.HyperGeometric}},
  \code{\link{pdf.HyperGeometric}},
  \code{\link{quantile.HyperGeometric}}
}
\concept{HyperGeometric distribution}
