% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/georange.R
\name{georange}
\alias{georange}
\title{Estimation of geographic ranges from occurrence data}
\usage{
georange(x, lng = NULL, lat = NULL, loc = NULL, method = "co")
}
\arguments{
\item{x}{\code{(data.frame)} Occurrence table containing the coordinates/locality memberships as variables.}

\item{lng}{(\code{character}) The variable name of the longitudes, required for the \code{"co"}, \code{"mst"} and \code{"mgcd"} methods.}

\item{lat}{(\code{character}) The variable name of the latitudes, required for the \code{"co"}, \code{"mst"} and \code{"mgcd"} methods.}

\item{loc}{(\code{character}) The variable name of the locality entries: cells, site or samples, required for the \code{"lo"} method.}

\item{method}{(\code{character}) Geographic range estimator method. Can take multiple entries (concatenating the results in a vector). The following methods are implemented: \code{"co"}: coordinate-based occupancy, the number of different coordinate pairs; \code{"lo"}: locality-based occupancy for sites, samples or geographic cells, number of different entries in a variable. \code{"mst"}, the total length of a minimum spanning tree of the point cloud, based on the great circle distances between points (requires the 'vegan' and 'icosa' packages). \code{"mgcd"}, maximum great-circle distance that can be measured in the point cloud (this version is limited to half the circumference of the equator, requires the 'icosa' package).}
}
\value{
A numeric vector with geographic ranges (multiple methods).
}
\description{
Geographic range as a function of a set of coordinates or sample/site/cell membeships.
}
\details{
Multiple estimators of geographic ranges are implemented based on coordinates or cell identifiers. The function outputs a vector of the results based on the calculation methods specified in \code{methods}.
}
\examples{
data(corals)
# select a  taxon from a certain time slice
  bitax <- corals[corals$stg==69 & corals$genus=="Microsolena",]
  georange(bitax, lng="paleolng", lat="paleolat", method="co")

}
