% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethod.R
\name{plotBouts,nls,data.frame-method}
\alias{plotBouts,nls,data.frame-method}
\alias{plotBouts}
\alias{plotBouts,nls,Bouts-method}
\alias{plotBouts,mle,numeric-method}
\alias{plotBouts,mle,Bouts-method}
\title{Plot fitted Poisson mixture model and data}
\usage{
\S4method{plotBouts}{nls,data.frame}(fit, obj, bec.lty = 2, ...)

\S4method{plotBouts}{nls,Bouts}(fit, obj, bec.lty = 2, ...)

\S4method{plotBouts}{mle,numeric}(fit, obj, xlab = "x", ylab = "Log Frequency", bec.lty = 2, ...)

\S4method{plotBouts}{mle,Bouts}(fit, obj, xlab = "x", ylab = "Log Frequency", bec.lty = 2, ...)
}
\arguments{
\item{fit}{Object of class \code{nls} or \code{mle}.}

\item{obj}{Object of class \code{\link{Bouts}},
\code{\link{data.frame}} with columns named \code{lnfreq} and
\code{x} (when \code{fit -> nls object}, or numeric vector (valid
when \code{fit -> mle object}.}

\item{bec.lty}{Line type specification for drawing the BEC reference
line.}

\item{...}{Arguments passed to \code{\link{plot.default}}.}

\item{xlab, ylab}{Label for x and y axis, respectively.}
}
\description{
Plot fitted Poisson mixture model and data
}
\section{Methods (by class)}{
\itemize{
\item \code{fit = nls,obj = data.frame}: Plot fitted \code{nls} model on \code{data.frame}
object

\item \code{fit = nls,obj = Bouts}: Plot fitted \code{nls} model on \code{Bouts}
object

\item \code{fit = mle,obj = numeric}: Plot fitted \code{mle} model on \code{numeric}
object

\item \code{fit = mle,obj = Bouts}: Plot fitted \code{mle} model on \code{Bouts}
object
}}

\seealso{
\code{\link{boutfreqs}}, \code{\link{fitNLSbouts}},
    \code{\link{fitMLEbouts}}
}
\author{
Sebastian P. Luque \email{spluque@gmail.com}
}
\keyword{methods}
\keyword{models}
\keyword{plot}
