% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probabilities.R
\name{probabilities}
\alias{probabilities}
\alias{probabilities.numeric}
\alias{probabilities.abundances}
\title{Probabilities of Species}
\usage{
probabilities(x, ...)

\method{probabilities}{numeric}(
  x,
  estimator = c("naive", "Chao2013", "Chao2015", "ChaoShen"),
  unveiling = c("none", "uniform", "geometric"),
  richness_estimator = c("jackknife", "iChao1", "Chao1", "rarefy", "naive"),
  jack_alpha = 0.05,
  jack_max = 10,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  q = 0,
  as_numeric = FALSE,
  ...,
  check_arguments = TRUE
)

\method{probabilities}{abundances}(
  x,
  estimator = c("naive", "Chao2013", "Chao2015", "ChaoShen"),
  unveiling = c("none", "uniform", "geometric"),
  richness_estimator = c("jackknife", "iChao1", "Chao1", "rarefy", "naive"),
  jack_alpha = 0.05,
  jack_max = 10,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  q = 0,
  ...,
  check_arguments = TRUE
)
}
\arguments{
\item{x}{An object. It may be:
\itemize{
\item a numeric vector containing abundances. It may be named to track species names.
\item an object of class \link{species_distribution}.
}}

\item{...}{Unused.}

\item{estimator}{One of the estimators of a probability distribution:
"naive" (the default value), or "Chao2013", "Chao2015", "ChaoShen" to estimate
the probabilities of the observed species in the asymptotic distribution.}

\item{unveiling}{One of the possible unveiling methods to estimate the probabilities
of the unobserved species: "none" (default, no species is added), "uniform"
(all unobserved species have the same probability) or "geometric" (the
unobserved species distribution is geometric).}

\item{richness_estimator}{An estimator of richness to evaluate the total number
of species. "jackknife" is the default value.
An alternative is "rarefy" to estimate the number of species such that the
entropy of the asymptotic distribution rarefied to the observed sample size equals
the actual entropy of the data.}

\item{jack_alpha}{The risk level, 5\% by default, used to optimize the jackknife order.}

\item{jack_max}{The highest jackknife order allowed. Default is 10.}

\item{coverage_estimator}{An estimator of sample coverage used by \link{coverage}.}

\item{q}{The order of diversity. Default is 0 for richness.
Used only to estimate asymptotic probability distributions when argument
\code{richness_estimator} is "rarefy". Then, the number of unobserved species is
fitted so that the entropy of order q of the asymptotic probability distribution
at the observed sample size equals the actual entropy of the data.}

\item{as_numeric}{If \code{TRUE}, a number or a numeric vector is returned rather than a tibble.}

\item{check_arguments}{If \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}
}
\value{
An object of class "probabilities", which is a \link{species_distribution}
or a numeric vector with argument \code{as_numeric = TRUE}.
}
\description{
Estimate actual probabilities of species from a sample
}
\details{
\code{probabilities()} estimates a probability distribution from a sample.
If the \code{estimator} is not "naive", the observed abundance distribution is used
to estimate the actual probability distribution.
The list of species is changed:
zero-abundance species are cleared, and some unobserved species are added.
First, observed species probabilities are estimated following
\insertCite{Chao2003;textual}{divent}, i.e. input probabilities are multiplied by
the sample coverage, or according to more sophisticated models:
\insertCite{Chao2013;textual}{divent}, a single-parameter model, or
\insertCite{Chao2015;textual}{divent}, a two-parameter model.
The total probability of observed species equals the sample coverage.
Then, the distribution of unobserved species can be unveiled: their number
is estimated according to the \code{richness_estimator}.
The coverage deficit (1 minus the sample coverage) is shared by the unobserved
species equally (\code{unveiling} = "uniform", \insertCite{Chao2013}{divent}) or
according to a geometric distribution (\code{unveiling} = "geometric", \insertCite{Chao2015}{divent}).
}
\examples{
# Just transform abundances into probabilities
probabilities(paracou_6_abd)
# Estimate the distribution of probabilities from observed abundances (unveiled probabilities)
prob_unv <- probabilities(
  paracou_6_abd, 
  estimator = "Chao2015", 
  unveiling = "geometric",
  richness_estimator = "jackknife"
)
# Estimate entropy from the unveiled probabilities
ent_shannon(prob_unv)
# Identical to
ent_shannon(paracou_6_abd, estimator = "UnveilJ")

}
\references{
\insertAllCited{}
}
