% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile_hill.R
\name{profile_hill}
\alias{profile_hill}
\alias{profile_hill.numeric}
\alias{profile_hill.species_distribution}
\title{Diversity Profile of a Community}
\usage{
profile_hill(x, orders = seq(from = 0, to = 2, by = 0.1), ...)

\method{profile_hill}{numeric}(
  x,
  orders = seq(from = 0, to = 2, by = 0.1),
  estimator = c("UnveilJ", "ChaoJost", "ChaoShen", "GenCov", "Grassberger", "Holste",
    "Marcon", "UnveilC", "UnveiliC", "ZhangGrabchak", "naive"),
  level = NULL,
  probability_estimator = c("Chao2015", "Chao2013", "ChaoShen", "naive"),
  unveiling = c("geometric", "uniform", "none"),
  richness_estimator = c("jackknife", "iChao1", "Chao1", "naive"),
  jack_alpha = 0.05,
  jack_max = 10,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  sample_coverage = NULL,
  as_numeric = FALSE,
  n_simulations = 0,
  alpha = 0.05,
  bootstrap = c("Chao2015", "Marcon2012", "Chao2013"),
  show_progress = TRUE,
  ...,
  check_arguments = TRUE
)

\method{profile_hill}{species_distribution}(
  x,
  orders = seq(from = 0, to = 2, by = 0.1),
  estimator = c("UnveilJ", "ChaoJost", "ChaoShen", "GenCov", "Grassberger", "Holste",
    "Marcon", "UnveilC", "UnveiliC", "ZhangGrabchak", "naive"),
  level = NULL,
  probability_estimator = c("Chao2015", "Chao2013", "ChaoShen", "naive"),
  unveiling = c("geometric", "uniform", "none"),
  richness_estimator = c("jackknife", "iChao1", "Chao1", "naive"),
  jack_alpha = 0.05,
  jack_max = 10,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  gamma = FALSE,
  n_simulations = 0,
  alpha = 0.05,
  bootstrap = c("Chao2015", "Marcon2012", "Chao2013"),
  show_progress = TRUE,
  ...,
  check_arguments = TRUE
)
}
\arguments{
\item{x}{An object, that may be a numeric vector containing abundances or probabilities,
or an object of class \link{abundances} or \link{probabilities}.}

\item{orders}{The orders of diversity used to build the profile.}

\item{...}{Unused.}

\item{estimator}{An estimator of entropy.}

\item{level}{The level of interpolation or extrapolation.
It may be a sample size (an integer) or a sample coverage
(a number between 0 and 1).
If not \code{NULL}, the asymptotic \code{estimator} is ignored.}

\item{probability_estimator}{A string containing one of the possible estimators
of the probability distribution (see \link{probabilities}).
Used only for extrapolation.}

\item{unveiling}{A string containing one of the possible unveiling methods
to estimate the probabilities of the unobserved species (see \link{probabilities}).
Used only for extrapolation.}

\item{richness_estimator}{An estimator of richness to evaluate the total number of species,
see \link{div_richness}. Used for interpolation and extrapolation.}

\item{jack_alpha}{The risk level, 5\% by default, used to optimize the jackknife order.}

\item{jack_max}{The highest jackknife order allowed. Default is 10.}

\item{coverage_estimator}{An estimator of sample coverage used by \link{coverage}.}

\item{sample_coverage}{The sample coverage of \code{x} calculated elsewhere.
Used to calculate the gamma diversity of meta-communities, see details.}

\item{as_numeric}{If \code{TRUE}, a number or a numeric vector is returned rather than a tibble.}

\item{n_simulations}{The number of simulations used to estimate the confidence envelope of the profile.}

\item{alpha}{The risk level, 5\% by default, of the confidence envelope of the profile.}

\item{bootstrap}{The method used to obtain the probabilities to generate
bootstrapped communities from observed abundances.
If "Marcon2012", the probabilities are simply the abundances divided by the total
number of individuals \insertCite{Marcon2012a}{divent}.
If "Chao2013" or "Chao2015" (by default), a more sophisticated approach is used
(see \link{as_probabilities}) following \insertCite{Chao2013;textual}{divent} or
\insertCite{Chao2015;textual}{divent}.}

\item{show_progress}{If TRUE, a progress bar is shown during long computations.}

\item{check_arguments}{If \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}

\item{gamma}{If \code{TRUE}, \eqn{\gamma} diversity, i.e. diversity of the metacommunity, is computed.}
}
\value{
A tibble with the site names, the estimators used and the estimated diversity at each order.
This is an object of class "profile" that can be plotted.
}
\description{
Calculate the diversity profile of a community, i.e. diversity (Hill numbers)
against its order.
}
\details{
A bootstrap confidence interval can be produced by simulating communities
(their number is \code{n_simulations}) with \link{rcommunity} and calculating their profiles.
Simulating communities implies a downward bias in the estimation:
rare species of the actual community may have abundance zero in simulated communities.
Simulated diversity values are recentered so that their mean is that of the actual community.
}
\examples{
autoplot(profile_hill(paracou_6_abd))

}
\references{
\insertAllCited{}
}
