% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abd_species.R
\name{abd_species}
\alias{abd_species}
\alias{abd_sum}
\alias{prob_species}
\title{Abundances of Communities}
\usage{
abd_species(abundances, check_arguments = TRUE)

abd_sum(abundances, as_numeric = FALSE, check_arguments = TRUE)

prob_species(species_distribution, check_arguments = TRUE)
}
\arguments{
\item{abundances}{an object of class \link{abundances}.}

\item{check_arguments}{if \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}

\item{as_numeric}{if \code{TRUE}, a number or a numeric vector is returned rather than a tibble.}

\item{species_distribution}{an object of class \link{species_distribution}.}
}
\value{
\code{abd_species()} returns a tibble containing the species abundance columns only,
to simplify numeric operations.

\code{prob_species()} returns the same tibble but values are probabilities.

\code{abd_sum()} returns the sample sizes of the communities in a numeric vector.
}
\description{
Utilities for community abundances (objects of class "abundances").
}
\examples{
abd_species(paracou_6_abd)
prob_species(paracou_6_abd)
abd_sum(paracou_6_abd)

}
