% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\name{autoplot.wmppp}
\alias{autoplot.wmppp}
\title{ggplot method to plot wmppp objects}
\usage{
\method{autoplot}{wmppp}(
  object,
  ...,
  show.window = TRUE,
  MaxPointTypes = 6,
  Other = "Other",
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  LegendLabels = NULL,
  labelSize = "Weight",
  labelColor = "Type",
  palette = "Set1",
  windowColor = "black",
  windowFill = "transparent",
  alpha = 1
)
}
\arguments{
\item{object}{an object to be plotted.}

\item{...}{extra arguments, currently unused.}

\item{show.window}{if \code{TRUE}, the borders of the window containing the points are shown on the point map.}

\item{MaxPointTypes}{the maximum number of different point types to show.
If the point set contains more of them, the less frequent ones are gathered as "Other".
This number must be limited for readability and not to exceed the number of colors offered by the palette.}

\item{Other}{the name of the point types gathered as "Other"}

\item{main}{the title of the plot.}

\item{xlab}{the X-axis label.}

\item{ylab}{the Y-axis label.}

\item{LegendLabels}{a vector of characters.
The first two items describe the observed and null-hypothesis curves, the third and last item the confidence interval.
To be used only in plots with two curves (typically observed and expected values).
The default is \code{NULL} to display the full description of functions.}

\item{labelSize}{the guide of the point size legend in point maps, i.e. what the \code{PointSize} mark represents.}

\item{labelColor}{the guide of the point color legend in point maps, i.e. what the \code{PointType} mark represents.}

\item{palette}{the color palette used to display point types in maps. See \link[ggplot2:scale_brewer]{ggplot2::scale_colour_brewer}.}

\item{windowColor}{the color used to draw the limits of the windows in point maps.}

\item{windowFill}{the color used to fill the windows in point maps.}

\item{alpha}{the opacity of the confidence envelope (in function values) or the points (in maps), between 0 and 1.}
}
\value{
A \link[ggplot2:ggplot]{ggplot2::ggplot}.
}
\description{
This method is from the dbmss package. See \link[dbmss:autoplot]{dbmss::autoplot.wmppp}.
}
\examples{
if (require("ggplot2")) {
  autoplot(paracou_6_wmppp) +
    # use radius scale because point sizes are already areas
    scale_radius() +
    labs(color = "Species", size = "Basal area")
}
}
