% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/div_part.R
\name{div_part}
\alias{div_part}
\title{Diversity partition}
\usage{
div_part(
  abundances,
  q = 1,
  estimator = c("UnveilJ", "ChaoJost", "ChaoShen", "GenCov", "Grassberger", "Holste",
    "Marcon", "UnveilC", "UnveiliC", "ZhangGrabchak"),
  level = NULL,
  probability_estimator = c("Chao2015", "Chao2013", "ChaoShen", "naive"),
  unveiling = c("geometric", "uniform", "none"),
  richness_estimator = c("jackknife", "iChao1", "Chao1", "naive"),
  jack_alpha = 0.05,
  jack_max = 10,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  q_threshold = 10,
  check_arguments = TRUE
)
}
\arguments{
\item{abundances}{an object of class \link{abundances}.}

\item{q}{a number: the order of diversity.}

\item{estimator}{An estimator of diversity.}

\item{level}{the level of interpolation or extrapolation.
It may be a sample size (an integer) or a sample coverage
(a number between 0 and 1).
If not \code{NULL}, the asymptotic \code{estimator} is ignored.}

\item{probability_estimator}{a string containing one of the possible estimators
of the probability distribution (see \link{probabilities}).
Used only for extrapolation.}

\item{unveiling}{a string containing one of the possible unveiling methods
to estimate the probabilities of the unobserved species (see \link{probabilities}).
Used only for extrapolation.}

\item{richness_estimator}{an estimator of richness to evaluate the total number of species,
see \link{div_richness}. used for interpolation and extrapolation.}

\item{jack_alpha}{the risk level, 5\% by default, used to optimize the jackknife order.}

\item{jack_max}{the highest jackknife order allowed. Default is 10.}

\item{coverage_estimator}{an estimator of sample coverage used by \link{coverage}.}

\item{q_threshold}{the value of \code{q} above which diversity is computed
directly with the naive estimator \eqn{(\sum{p_s^q}^{\frac{1}{(1-q)}}},
without computing entropy.
When \code{q} is great, the exponential of entropy goes to \eqn{0^{\frac{1}{(1-q)}}},
causing rounding errors while the naive estimator of diversity is less and
less biased.}

\item{check_arguments}{if \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}
}
\value{
A tibble with diversity values at each scale.
}
\description{
Calculate \eqn{\gamma}, \eqn{\beta} and \eqn{\alpha} diversities of a metacommunity.
}
\details{
The function computes \eqn{\gamma} diversity after building a metacommunity
from local communities according to their weight \insertCite{Marcon2014a}{divent}.
\eqn{\alpha} entropy is the weighted mean local entropy, converted into Hill
numbers to obtain \eqn{\alpha} diversity.
\eqn{\beta} diversity is obtained as the ratio of \eqn{\gamma} to \eqn{\alpha}.
}
\examples{
div_part(paracou_6_abd)

}
\references{
\insertAllCited{}
}
