% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/diversity.R
\name{u_distances}
\alias{u_distances}
\title{A procedure to create a disparity matrix from a data frame or a matrix}
\usage{
u_distances(data, method = "euclidean", entity_col = FALSE)
}
\arguments{
\item{data}{A numeric matrix with entities \eqn{i} in the rows and categories \eqn{j} in the columns. Cells show the respective value (value of abundance) of entity \eqn{i} in the category \eqn{j}. It can also be a transpose of the previous matrix, that is, a matrix with categories in the rows and entities in the columns. Yet in that case, the parameter "entity_col" has to be set to TRUE. The matrix must include names for the rows and the columns. The parameter "data", also accepts a dataframe with three columns in the following order: entity, category and value.}

\item{method}{A distance or dissimilarity method available in "proxy" package as for example "Euclidean", "Kullback" or "Canberra". This parameter also accepts a similarity method available in the "proxy" package, as for example: "cosine", "correlation" or "Jaccard" among others. In the latter case, a correspondent transformation to a dissimilarity measure will be retrieved. A list of available methods can be queried by using the function \code{\link[proxy]{pr_DB}}. e.g. summary(pr_DB). The default value is Euclidean distance.}

\item{entity_col}{A flag to indicate that entities are in the columns. The analysis assumes that the entities are in the rows of the matrix. If the entities are in the columns and the categories in the rows, then the parameter "entity_col" has to be set to TRUE. The default value is FALSE.}
}
\value{
A distance or dissimilarity square matrix
}
\description{
It takes a data frame or a matrix to create a disparity matrix
}
\examples{
Xdis <- u_distances(pantheon)
Xdis <- u_distances(pantheon, method="jaccard", entity_col=TRUE)
Xdis <- u_distances(pantheon, method="cosine", entity_col=TRUE)
}

