#' @details staff_records - Staff record with some missing data
#' @usage data(staff_records)
#' @format data.frame
#' @rdname patient_list
#' @examples
#' data(staff_records)
"staff_records"

#' @details missing_staff_id - Staff records with missing staff identifiers
#' @usage data(missing_staff_id)
#' @format data.frame
#' @rdname patient_list
#' @examples
#' data(missing_staff_id)
"missing_staff_id"

#' @rdname patient_list
#' @details infections, infections_2, infections_3 and infections_4 - Reports of bacterial infections
#' @usage data(infections)
#' @format data.frame
#' @examples
#' data(infections)
"infections"

#' @rdname patient_list
#' @usage data(infections_2)
#' @format data.frame
#' @examples
#' data(infections_2)
"infections_2"

#' @rdname patient_list
#' @usage data(infections_3)
#' @format data.frame
#' @examples
#' data(infections_3)
"infections_3"

#' @rdname patient_list
#' @usage data(infections_4)
#' @format data.frame
#' @examples
#' data(infections_4)
"infections_4"

#' @details hospital_admissions - Hospital admissions and discharges
#' @usage data(hospital_admissions)
#' @format data.frame
#' @rdname patient_list
#' @examples
#' data(hospital_admissions)
"hospital_admissions"

#' @title Datasets in \code{diyar} package
#' @details patient_list & patient_list_2 - Patient list with some missing data
#' @docType data
#' @usage data(patient_list)
#' @format data.frame
#' @keywords datasets
#' @aliases patient_list
#' @examples
#' data(patient_list)
"patient_list"

#' @rdname patient_list
#' @usage data(patient_list_2)
#' @examples
#' data(patient_list_2)
"patient_list_2"

#' @details Hourly data
#' @usage data(hourly_data)
#' @format data.frame
#' @rdname patient_list
#' @examples
#' data(hourly_data)
"hourly_data"

#' @details Opes - List of individuals with the same name
#' @usage data(Opes)
#' @format data.frame
#' @rdname patient_list
#' @examples
#' data(Opes)
"Opes"

#' @details Duration in seconds for each 'episode_unit'
#' @usage data(episode_unit)
#' @format list
#' @rdname patient_list
#' @examples
#' data(episode_unit)
"episode_unit"

#' @details Permutations of \code{\link{number_line}} overlap methods
#' @usage data(overlap_methods)
#' @format list
#' @rdname patient_list
#' @examples
#' data(overlap_methods)
"overlap_methods"
