% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{pane-class}
\alias{pane-class}
\alias{is.pane}
\alias{as.pane}
\alias{format.pane}
\alias{unique.pane}
\alias{summary.pane}
\alias{print.pane_summary}
\alias{as.data.frame.pane}
\alias{as.list.pane}
\alias{show,pane-method}
\alias{rep,pane-method}
\alias{[,pane-method}
\alias{[[,pane-method}
\alias{c,pane-method}
\title{\code{pane} object}
\usage{
is.pane(x)

as.pane(x)

\method{format}{pane}(x, ...)

\method{unique}{pane}(x, ...)

\method{summary}{pane}(object, ...)

\method{print}{pane_summary}(x, ...)

\method{as.data.frame}{pane}(x, ...)

\method{as.list}{pane}(x, ...)

\S4method{show}{pane}(object)

\S4method{rep}{pane}(x, ...)

\S4method{[}{pane}(x, i, j, ..., drop = TRUE)

\S4method{[[}{pane}(x, i, j, ..., exact = TRUE)

\S4method{c}{pane}(x, ...)
}
\arguments{
\item{x}{x}

\item{...}{...}

\item{object}{object}

\item{i}{i}

\item{j}{j}

\item{drop}{drop}

\item{exact}{exact}
}
\description{
S4 objects storing the result of \code{\link{partitions}}.
}
\section{Slots}{

\describe{
\item{\code{sn}}{Unique record identifier.}

\item{\code{.Data}}{Unique \code{pane} identifier.}

\item{\code{case_nm}}{Record type in regards to index assignment.}

\item{\code{window_list}}{A list of considered \code{windows} for each \code{pane}.}

\item{\code{dist_pane_index}}{The difference between each event and it's index event.}

\item{\code{pane_dataset}}{Data sources in each \code{pane}.}

\item{\code{pane_interval}}{The start and end dates of each \code{pane}. A \code{\link{number_line}} object.}

\item{\code{pane_length}}{The duration or length of (\code{pane_interval}).}

\item{\code{pane_total}}{The number of records in each \code{pane}.}

\item{\code{options}}{Some options passed to the instance of \code{\link{partitions}}.}

\item{\code{window_matched}}{A list of matched \code{windows} for each \code{pane}.}
}}

\examples{
# A test for pane objects
pn <- partitions(date = 1, by = 1)
is.pane(pn); is.pane(2)

}
