% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cumulative.R
\name{plot_cumulative}
\alias{plot_cumulative}
\title{Plot Distributed Lag Function}
\usage{
plot_cumulative(
  new_modifiers,
  mod_fit,
  dlm_fit = NULL,
  mod_name = NULL,
  mod_trans = NULL,
  link_trans = NULL
)
}
\arguments{
\item{new_modifiers}{a vector of new modifier values for prediction (class "\code{numeric}")}

\item{mod_fit}{DLIM model object (class "\code{dlim}")}

\item{dlm_fit}{a list containing a \code{crossbasis} object from the \pkg{dlnm} package as the first element and a DLM model object as the second element (class "\code{list}")}

\item{mod_name}{modifier name (character)}

\item{mod_trans}{if modifiers are transformed, specify back transformation function (class "\code{character}")}

\item{link_trans}{if family for \code{glm} is not Gaussian, specify back transformation to undo link function (class "\code{character}")}
}
\value{
This function returns a ggplot for cumulative effects, including for a DLM if specified
}
\description{
Plot estimated distributed lag function values from a DLIM object, can also compare those of a DLM
}
\seealso{
\link[dlim]{dlim}

Type \code{vignette('dlimOverview')} for a detailed description.
}
