% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.dlim.R
\name{predict.dlim}
\alias{predict.dlim}
\title{DLIM Predictions}
\usage{
\method{predict}{dlim}(
  object,
  newdata = NULL,
  type = c("DLF", "CE", "response"),
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{object}{an object of class "\code{dlim}"}

\item{newdata}{a vector of new modifier values for prediction (class "\code{numeric}")}

\item{type}{Type of prediction. "DLF" for the estimated distributed lag functions, "CE" for cumulative effects, "response" for fitted values, or any combination of these in a vector (class "\code{character}")}

\item{conf.level}{The confidence level (class "\code{numeric}")}

\item{...}{additional arguments affecting the predictions produced}
}
\value{
This function returns a list of 3 elements:
\item{est_dlim}{cumulative and/or point-wise estimates, standard errors, and confidence intervals (class "\code{list}")}
\item{cb}{cross-basis object (class "\code{cross-basis}")}
\item{model}{model object (class "\code{gam}")}
}
\description{
Predicted values based on a \code{dlim} object.
}
\seealso{
\link[dlim]{dlim}

Type \code{vignette('dlimOverview')} for a detailed description.
}
