% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_dbi.R
\name{plot_correlate.tbl_dbi}
\alias{plot_correlate.tbl_dbi}
\title{Visualize correlation plot of numerical data}
\usage{
\method{plot_correlate}{tbl_dbi}(.data, ..., in_database = FALSE, collect_size = Inf)
}
\arguments{
\item{.data}{a tbl_dbi.}

\item{...}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, plot_correlate() will automatically start with all variables.
These arguments are automatically quoted and evaluated in a context where column names
represent column positions.
They support unquoting and splicing.}

\item{in_database}{Specifies whether to perform in-database operations. 
If TRUE, most operations are performed in the DBMS. if FALSE, 
table data is taken in R and operated in-memory. Not yet supported in_database = TRUE.}

\item{collect_size}{a integer. The number of data samples from the DBMS to R. 
Applies only if in_database = FALSE.

See vignette("EDA") for an introduction to these concepts.}
}
\description{
The plot_correlate() visualize correlation plot
for find relationship between two numerical(INTEGER, NUMBER, etc.) column of 
the DBMS table through tbl_dbi.
}
\details{
The scope of the visualization is the provide a correlation information.
Since the plot is drawn for each variable, if you specify more than
one variable in the ... argument, the specified number of plots are drawn.
}
\examples{
library(dplyr)

# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# connect DBMS
con_sqlite <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")

# copy carseats to the DBMS with a table named TB_CARSEATS
copy_to(con_sqlite, carseats, name = "TB_CARSEATS", overwrite = TRUE)

# Using pipes ---------------------------------
# Visualize correlation plot of all numerical variables
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  plot_correlate()
  
# Positive values select variables, and In-memory mode and collect size is 200
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  plot_correlate(Sales, Price, collect_size = 200)
  
# Negative values to drop variables
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  plot_correlate(-Sales, -Price)
  
# Positions values select variables
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  plot_correlate(1)
  
# Positions values select variables
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  plot_correlate(-1, -2, -3, -5, -6)

# Using pipes & dplyr -------------------------
# Visualize correlation plot of 'Sales' variable by 'ShelveLoc'
# and 'US' variables.
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  group_by(ShelveLoc, US) \%>\%
  plot_correlate(Sales)

# Extract only those with 'ShelveLoc' variable level is "Good",
# and visualize correlation plot of 'Sales' variable by 'Urban'
# and 'US' variables.
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  filter(ShelveLoc == "Good") \%>\%
  group_by(Urban, US) \%>\%
  plot_correlate(Sales)
 
}
\seealso{
\code{\link{plot_correlate.data.frame}}, \code{\link{plot_outlier.tbl_dbi}}.
}
