% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{plot.optimal_bins}
\alias{plot.optimal_bins}
\title{Visualize Distribution for an "optimal_bins" Object}
\usage{
\method{plot}{optimal_bins}(
  x,
  type = c("all", "dist", "freq", "posrate", "WoE"),
  typographic = TRUE,
  ...
)
}
\arguments{
\item{x}{an object of class "optimal_bins", usually, a result of a call to binning_by().}

\item{type}{character. options for visualization. Distribution ("dist"), Relateive Frequency ("freq"),
Positive Rate ("posrate"), and Weight of Evidence ("WoE"). and default "all" draw all plot.}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}

\item{...}{further arguments to be passed from or to other methods.}
}
\description{
It generates plots for understand distribution, frequency, bad rate, and weight of evidence using optimal_bins.

See vignette("transformation") for an introduction to these concepts.
}
\examples{
# Generate data for the example
heartfailure2 <- heartfailure
heartfailure2[sample(seq(NROW(heartfailure2)), 5), "creatinine"] <- NA

# optimal binning using binning_by()
bin <- binning_by(heartfailure2, "death_event", "creatinine")
bin

# summary optimal_bins class.
summary(bin)

# visualize all information for optimal_bins class
plot(bin)

# visualize WoE information for optimal_bins class
plot(bin, type = "WoE")

# visualize all information with typographic
plot(bin)

}
\seealso{
\code{\link{binning_by}}, \code{\link{summary.optimal_bins}}
}
