% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overview.R
\name{plot.overview}
\alias{plot.overview}
\title{Visualize Information for an "overview" Object}
\usage{
\method{plot}{overview}(x, order_type = c("none", "name", "type"), ...)
}
\arguments{
\item{x}{an object of class "overview", usually, a result of a call to overview().}

\item{order_type}{character. method of order of bars(variables).}

\item{...}{further arguments to be passed from or to other methods.}
}
\description{
Visualize a plot by attribute of `overview` class.
Visualize the data type, number of observations, and number of missing values for each variable.
}
\examples{
\donttest{
ov <- overview(jobchange)
ov

summary(ov)

plot(ov)

# sort by name of variables
plot(ov, order_type = "name")

# sort by data type of variables
plot(ov, order_type = "type")
}

}
\seealso{
\code{\link{overview}}, \code{\link{summary.overview}}.
}
