% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing.R
\name{plot_na_pareto}
\alias{plot_na_pareto}
\title{Pareto chart for missing value}
\usage{
plot_na_pareto(
  x,
  only_na = FALSE,
  relative = FALSE,
  main = NULL,
  col = "black",
  grade = list(Good = 0.05, OK = 0.1, NotBad = 0.2, Bad = 0.5, Remove = 1),
  plot = TRUE,
  typographic = TRUE
)
}
\arguments{
\item{x}{data frames, or objects to be coerced to one.}

\item{only_na}{logical. The default value is FALSE. 
If TRUE, only variables containing missing values are selected for visualization. 
If FALSE, all variables are included.}

\item{relative}{logical. If this argument is TRUE, it sets the unit of the left y-axis to relative frequency. 
In case of FALSE, set it to frequency.}

\item{main}{character. Main title.}

\item{col}{character. The color of line for display the cumulative percentage.}

\item{grade}{list. Specifies the cut-off to set the grade of the variable according to the ratio of missing values.
The default values are Good: [0, 0.05], OK: (0.05, 0.1], NotBad: (0.1, 0.2], Bad: (0.2, 0.5], Remove: (0.5, 1].}

\item{plot}{logical. If this value is TRUE then visualize plot. else if FALSE, return aggregate information about missing values.}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}
}
\description{
Visualize pareto chart for variables with missing value.
}
\examples{
# Generate data for the example
set.seed(123L)
jobchange2 <- jobchange[sample(nrow(jobchange), size = 1000), ]

# Diagnose the data with missing_count using diagnose() function
library(dplyr)

jobchange2 \%>\% 
  diagnose \%>\% 
  arrange(desc(missing_count))

# Visualize pareto chart for variables with missing value.
plot_na_pareto(jobchange2)

# Visualize pareto chart for variables with missing value.
plot_na_pareto(jobchange2, col = "blue")

# Visualize only variables containing missing values
plot_na_pareto(jobchange2, only_na = TRUE)

# Display the relative frequency 
plot_na_pareto(jobchange2, relative = TRUE)

# Change the grade
plot_na_pareto(jobchange2, grade = list(High = 0.1, Middle = 0.6, Low = 1))

# Change the main title.
plot_na_pareto(jobchange2, relative = TRUE, only_na = TRUE, 
               main = "Pareto Chart for jobchange")
  
# Return the aggregate information about missing values.
plot_na_pareto(jobchange2, only_na = TRUE, plot = FALSE)

# Not support typographic elements
plot_na_pareto(jobchange2, typographic = FALSE)

}
