% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_dbi.R
\name{diagnose.tbl_dbi}
\alias{diagnose.tbl_dbi}
\title{Diagnose data quality of variables in the DBMS}
\usage{
\method{diagnose}{tbl_dbi}(.data, ..., in_database = TRUE, collect_size = Inf)
}
\arguments{
\item{.data}{a tbl_dbi.}

\item{...}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, diagnose() will automatically start with all variables.
These arguments are automatically quoted and evaluated in a context where column names
represent column positions.
They support unquoting and splicing.}

\item{in_database}{a logical. Specifies whether to perform in-database operations. 
If TRUE, most operations are performed in the DBMS. if FALSE, 
table data is taken in R and operated in-memory.}

\item{collect_size}{a integer. The number of data samples from the DBMS to R. 
Applies only if in_database = FALSE.}
}
\value{
An object of tbl_df.
}
\description{
The diagnose() produces information for diagnosing the quality of 
the column of the DBMS table through tbl_dbi.
}
\details{
The scope of data quality diagnosis is information on missing values
and unique value information. Data quality diagnosis can determine variables
that require missing value processing. Also, the unique value information can
determine the variable to be removed from the data analysis.
}
\section{Diagnostic information}{

The information derived from the data diagnosis is as follows.:

\itemize{
\item variables : column names
\item types : data type of the variable
or to select a variable to be corrected or removed through data diagnosis.
  \itemize{
    \item integer, numeric, factor, ordered, character, etc.
  }
\item missing_count : number of missing values
\item missing_percent : percentage of missing values
\item unique_count : number of unique values
\item unique_rate : ratio of unique values. unique_count / number of observation
}

See vignette("diagonosis") for an introduction to these concepts.
}

\examples{
library(dplyr)

# connect DBMS
con_sqlite <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")

# copy jobchange to the DBMS with a table named TB_JOBCHANGE
copy_to(con_sqlite, jobchange, name = "TB_JOBCHANGE", overwrite = TRUE)

# Using pipes ---------------------------------
# Diagnosis of all columns
con_sqlite \%>\% 
  tbl("TB_JOBCHANGE") \%>\% 
  diagnose()
  
# Positive values select columns
# con_sqlite \%>\% 
#   tbl("TB_JOBCHANGE") \%>\% 
#   diagnose(gender, education_level, company_size)
  
# Negative values to drop columns
# con_sqlite \%>\% 
#   tbl("TB_JOBCHANGE") \%>\% 
#   diagnose(-gender, -education_level, -company_size)
  
# Positions values select columns, and In-memory mode
# con_sqlite \%>\% 
#   tbl("TB_JOBCHANGE") \%>\% 
#   diagnose(1, 3, 8, in_database = FALSE)
  
# Positions values select columns, and In-memory mode and collect size is 200
# con_sqlite \%>\% 
#   tbl("TB_JOBCHANGE") \%>\% 
#   diagnose(-8, -9, -10, in_database = FALSE, collect_size = 200)

# Using pipes & dplyr -------------------------
# Diagnosis of missing variables
con_sqlite \%>\% 
  tbl("TB_JOBCHANGE") \%>\% 
  diagnose() \%>\%
  filter(missing_count > 0)
  
# Disconnect DBMS   
DBI::dbDisconnect(con_sqlite)
  
}
\seealso{
\code{\link{diagnose.data.frame}}, \code{\link{diagnose_category.tbl_dbi}}, \code{\link{diagnose_numeric.tbl_dbi}}.
}
