% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/target_by.R
\name{plot.relate}
\alias{plot.relate}
\title{Visualize Information for an "relate" Object}
\usage{
\method{plot}{relate}(
  x,
  model = FALSE,
  hex_thres = 1000,
  pal = c("#FFFFB2", "#FED976", "#FEB24C", "#FD8D3C", "#FC4E2A", "#E31A1C", "#B10026"),
  typographic = TRUE,
  base_family = NULL,
  ...
)
}
\arguments{
\item{x}{an object of class "relate", usually, a result of a call to relate().}

\item{model}{logical. This argument selects whether to output the visualization result
to the visualization of the object of the lm model to grasp the relationship between
the numerical variables.}

\item{hex_thres}{an integer. Use only when the target and predictor are numeric variables.
Used when the number of observations is large. 
Specify the threshold of the observations to draw hexabin plots that are not scatterplots. 
The default value is 1000.}

\item{pal}{Color palette to paint hexabin. Use only when the target and predictor are numeric variables.
Applied only when the number of observations is greater than hex_thres.}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}

\item{base_family}{character. The name of the base font family to use 
for the visualization. If not specified, the font defined in dlookr is applied. (See details)}

\item{...}{arguments to be passed to methods, such as graphical parameters (see par).
only applies when the model argument is TRUE, and is used for ... of the plot.lm() function.}
}
\description{
Visualize four kinds of plot by attribute of relate class.
}
\details{
The base_family is selected from "Roboto Condensed", "Liberation Sans Narrow",
"NanumSquare", "Noto Sans Korean". If you want to use a different font, 
use it after loading the Google font with import_google_font().
}
\examples{
# If the target variable is a categorical variable
categ <- target_by(heartfailure, death_event)

# If the variable of interest is a numerical variable
cat_num <- relate(categ, sodium)
cat_num
summary(cat_num)

plot(cat_num)

# If the variable of interest is a categorical variable
cat_cat <- relate(categ, hblood_pressure)
cat_cat
summary(cat_cat)
 
plot(cat_cat)

##---------------------------------------------------
# If the target variable is a numerical variable
num <- target_by(heartfailure, creatinine)

# If the variable of interest is a numerical variable
num_num <- relate(num, sodium)
num_num
summary(num_num)

plot(num_num)

# If the variable of interest is a categorical variable
num_cat <- relate(num, smoking)
num_cat
summary(num_cat)

plot(num_cat)

# Not allow typographic
plot(num_cat, typographic = FALSE)
 
}
\seealso{
\code{\link{relate}}, \code{\link{print.relate}}.
}
