% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_dbi.R
\name{plot_outlier.tbl_dbi}
\alias{plot_outlier.tbl_dbi}
\title{Plot outlier information of numerical data diagnosis in the DBMS}
\usage{
\method{plot_outlier}{tbl_dbi}(
  .data,
  ...,
  col = "steelblue",
  in_database = FALSE,
  collect_size = Inf,
  typographic = TRUE,
  base_family = NULL
)
}
\arguments{
\item{.data}{a tbl_dbi.}

\item{...}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, plot_outlier() will automatically start
with all variables.
These arguments are automatically quoted and evaluated in a context
where column names represent column positions.
They support unquoting and splicing.}

\item{col}{a color to be used to fill the bars. The default is "lightblue".}

\item{in_database}{Specifies whether to perform in-database operations. 
If TRUE, most operations are performed in the DBMS. if FALSE, 
table data is taken in R and operated in-memory. Not yet supported in_database = TRUE.}

\item{collect_size}{a integer. The number of data samples from the DBMS to R. 
Applies only if in_database = FALSE.}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}

\item{base_family}{character. The name of the base font family to use 
for the visualization. If not specified, the font defined in dlookr is applied. (See details)}
}
\description{
The plot_outlier() visualize outlier information
for diagnosing the quality of the numerical(INTEGER, NUMBER, etc.) column 
of the DBMS table through tbl_dbi.
}
\details{
The scope of the diagnosis is the provide a outlier information.
Since the plot is drawn for each variable, if you specify more than
one variable in the ... argument, the specified number of plots are drawn.
}
\section{Outlier diagnostic information}{

The plot derived from the numerical data diagnosis is as follows.

\itemize{
\item With outliers box plot
\item Without outliers box plot
\item With outliers histogram
\item Without outliers histogram
}

See vignette("diagonosis") for an introduction to these concepts.

The base_family is selected from "Roboto Condensed", "Liberation Sans Narrow",
"NanumSquare", "Noto Sans Korean". If you want to use a different font, 
use it after loading the Google font with import_google_font().
}

\examples{
\donttest{
library(dplyr)

# connect DBMS
con_sqlite <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")

# copy heartfailure to the DBMS with a table named TB_HEARTFAILURE
copy_to(con_sqlite, heartfailure, name = "TB_HEARTFAILURE", overwrite = TRUE)

# Using pipes ---------------------------------
# Visualization of all numerical variables
con_sqlite \%>\% 
  tbl("TB_HEARTFAILURE") \%>\% 
  plot_outlier()
  
# Positive values select variables
 con_sqlite \%>\% 
   tbl("TB_HEARTFAILURE") \%>\% 
   plot_outlier(platelets, sodium)
  
# Negative values to drop variables, and In-memory mode and collect size is 200
con_sqlite \%>\% 
  tbl("TB_HEARTFAILURE") \%>\% 
  plot_outlier(-platelets, -sodium, collect_size = 200)
  
# Positions values select variables
con_sqlite \%>\% 
  tbl("TB_HEARTFAILURE") \%>\% 
  plot_outlier(6)
  
# Negative values to drop variables
con_sqlite \%>\% 
  tbl("TB_HEARTFAILURE") \%>\% 
  plot_outlier(-1, -5)
  
# Not allow the typographic elements
con_sqlite \%>\% 
  tbl("TB_HEARTFAILURE") \%>\% 
  plot_outlier(-1, -5, typographic = FALSE)

# Using pipes & dplyr -------------------------
# Visualization of numerical variables with a ratio of
# outliers greater than 1\%
con_sqlite \%>\% 
  tbl("TB_HEARTFAILURE") \%>\% 
  plot_outlier(con_sqlite \%>\% 
                 tbl("TB_HEARTFAILURE") \%>\% 
                 diagnose_outlier() \%>\%
                 filter(outliers_ratio > 1) \%>\%
                 select(variables) \%>\%
                 pull())

# Disconnect DBMS   
DBI::dbDisconnect(con_sqlite)
}
      
}
\seealso{
\code{\link{plot_outlier.data.frame}}, \code{\link{diagnose_outlier.tbl_dbi}}.
}
