% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{binning_rgr}
\alias{binning_rgr}
\title{Binning by recursive information gain ratio maximization}
\usage{
binning_rgr(.data, y, x, min_perc_bins = 0.1, max_n_bins = 5, ordered = TRUE)
}
\arguments{
\item{.data}{a data frame.}

\item{y}{character. name of binary response variable. 
The variable must character of factor.}

\item{x}{character. name of continuous characteristic variable. 
At least 5 different values. and Inf is not allowed.}

\item{min_perc_bins}{numeric. minimum percetange of rows for each split or 
segment (controls the sample size), 0.1 (or 10 percent) as default.}

\item{max_n_bins}{integer. maximum number of bins or segments 
to split the input variable, 5 bins as default.}

\item{ordered}{logical. whether to build an ordered factor or not.}
}
\value{
an object of "infogain_bins" class.
Attributes of "infogain_bins" class is as follows.
\itemize{
\item class : "infogain_bins".
\item type : binning type, "infogain".
\item breaks : numeric. the number of intervals into which x is to be cut.
\item levels : character. levels of binned value.
\item raw : numeric. raw data, x argument value.
\item target : integer. binary response variable.
\item x_var : character. name of x variable.
\item y_var : character. name of y variable.
}
}
\description{
The binning_rgr() finding intervals for numerical variable
using recursive information gain ratio maximization.
}
\details{
This function can be usefully used when developing a model that predicts y.
}
\examples{
\donttest{
library(dplyr)

# binning by recursive information gain ratio maximization using character
bin <- binning_rgr(heartfailure, "death_event", "creatinine")

# binning by recursive information gain ratio maximization using name
bin <- binning_rgr(heartfailure, death_event, creatinine)
bin

# summary optimal_bins class
summary(bin)

# visualize all information for optimal_bins class
plot(bin)

# visualize WoE information for optimal_bins class
plot(bin, type = "cross")

# visualize all information without typographic
plot(bin, type = "cross", typographic = FALSE)

# extract binned results
extract(bin) \%>\% 
  head(20)
}

}
\seealso{
\code{\link{binning}}, \code{\link{binning_by}}, \code{\link{plot.infogain_bins}}.
}
