% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_dbi.R
\name{target_by.tbl_dbi}
\alias{target_by.tbl_dbi}
\title{Target by one column in the DBMS}
\usage{
\method{target_by}{tbl_dbi}(.data, target, in_database = FALSE, collect_size = Inf, ...)
}
\arguments{
\item{.data}{a tbl_dbi.}

\item{target}{target variable.}

\item{in_database}{Specifies whether to perform in-database operations. 
If TRUE, most operations are performed in the DBMS. if FALSE, 
table data is taken in R and operated in-memory. Not yet supported in_database = TRUE.}

\item{collect_size}{a integer. The number of data samples from the DBMS to R.
Applies only if in_database = FALSE.}

\item{...}{arguments to be passed to methods.}
}
\value{
an object of target_df class.
Attributes of target_df class is as follows.
\itemize{
\item type_y : the data type of target variable.
}
}
\description{
In the data analysis, a target_df class is created to identify the
relationship between the target column and the other column of the DBMS table through tbl_dbi
}
\details{
Data analysis proceeds with the purpose of predicting target variables that
 correspond to the facts of interest, or examining associations and
 relationships with other variables of interest.
 Therefore, it is a major challenge for EDA to examine the relationship
 between the target variable and its corresponding variable.
 Based on the derived relationships, analysts create scenarios for data analysis.

 target_by() inherits the \code{\link{grouped_df}} class and returns a target_df
 class containing information about the target variable and the variable.

See vignette("EDA") for an introduction to these concepts.
}
\examples{
# If you have the 'DBI' and 'RSQLite' packages installed, perform the code block:
if (FALSE) {
library(dplyr)

# connect DBMS
con_sqlite <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")

# copy heartfailure to the DBMS with a table named TB_HEARTFAILURE
copy_to(con_sqlite, heartfailure, name = "TB_HEARTFAILURE", overwrite = TRUE)

# If the target variable is a categorical variable
categ <- target_by(con_sqlite \%>\% tbl("TB_HEARTFAILURE") , death_event)

# If the variable of interest is a numerical variable
cat_num <- relate(categ, sodium)
cat_num
summary(cat_num)
plot(cat_num)

# If the variable of interest is a categorical column
cat_cat <- relate(categ, hblood_pressure)
cat_cat
summary(cat_cat)
plot(cat_cat)

##---------------------------------------------------
# If the target variable is a categorical column, 
# and In-memory mode and collect size is 200
num <- target_by(con_sqlite \%>\% tbl("TB_HEARTFAILURE"), death_event, collect_size = 250)

# If the variable of interest is a numerical column
num_num <- relate(num, creatinine)
num_num
summary(num_num)
plot(num_num)
plot(num_num, hex_thres = 200)

# If the variable of interest is a categorical column
num_cat <- relate(num, smoking)
num_cat
summary(num_cat)
plot(num_cat)

# Disconnect DBMS   
DBI::dbDisconnect(con_sqlite)
}

}
\seealso{
\code{\link{target_by.data.frame}}, \code{\link{relate}}.
}
