% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw-dm.R
\name{dm_draw}
\alias{dm_draw}
\title{Draw a diagram of the data model}
\usage{
dm_draw(
  dm,
  rankdir = "LR",
  col_attr = NULL,
  view_type = c("keys_only", "all", "title_only"),
  columnArrows = TRUE,
  graph_attrs = "",
  node_attrs = "",
  edge_attrs = "",
  focus = NULL,
  graph_name = "Data Model",
  ...,
  column_types = NULL
)
}
\arguments{
\item{dm}{A \code{\link{dm}} object.}

\item{rankdir}{Graph attribute for direction (e.g., 'BT' = bottom --> top).}

\item{col_attr}{Deprecated, use \code{colummn_types} instead.}

\item{view_type}{Can be "keys_only" (default), "all" or "title_only".
It defines the level of details for rendering tables
(only primary and foreign keys, all columns, or no columns).}

\item{columnArrows}{Edges from columns to columns (default: \code{TRUE}).}

\item{graph_attrs}{Additional graph attributes.}

\item{node_attrs}{Additional node attributes.}

\item{edge_attrs}{Additional edge attributes.}

\item{focus}{A list of parameters for rendering (table filter).}

\item{graph_name}{The name of the graph.}

\item{...}{These dots are for future extensions and must be empty.}

\item{column_types}{Set to \code{TRUE} to show column types.}
}
\value{
An object of class \code{grViz} (see also \code{\link[DiagrammeR:grViz]{DiagrammeR::grViz()}}), which,
when printed, produces the output seen in the viewer as a side effect.
}
\description{
\code{dm_draw()} uses \pkg{DiagrammeR} to draw diagrams.
Use \code{\link[DiagrammeRsvg:export_svg]{DiagrammeRsvg::export_svg()}} to convert the diagram to an SVG file.
}
\examples{
\dontshow{if (rlang::is_installed("nycflights13") && rlang::is_installed("DiagrammeR")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dm_nycflights13() \%>\%
  dm_draw()

dm_nycflights13(cycle = TRUE) \%>\%
  dm_draw(view_type = "title_only")

head(dm_get_available_colors())
length(dm_get_available_colors())

dm_nycflights13() \%>\%
  dm_get_colors()
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=dm_set_colors]{dm_set_colors()}} for defining the table colors.
}
