% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm_wrap.R
\name{dm_unwrap_tbl}
\alias{dm_unwrap_tbl}
\title{Unwrap a single table dm}
\usage{
dm_unwrap_tbl(dm, ptype)
}
\arguments{
\item{dm}{A dm.}

\item{ptype}{A dm, only used to query names of primary and foreign keys.}
}
\value{
A dm.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{dm_unwrap_tbl()} unwraps all tables in a dm object so that the resulting dm
matches a given ptype dm.
It runs a sequence of \code{\link[=dm_unnest_tbl]{dm_unnest_tbl()}} and \code{\link[=dm_unpack_tbl]{dm_unpack_tbl()}} operations
on the dm.
}
\examples{

roundtrip <-
  dm_nycflights13() \%>\%
  dm_wrap_tbl(root = flights) \%>\%
  dm_unwrap_tbl(ptype = dm_ptype(dm_nycflights13()))
roundtrip

# The roundtrip has the same structure but fewer rows:
dm_nrow(dm_nycflights13())
dm_nrow(roundtrip)
}
\seealso{
\code{\link[=dm_wrap_tbl]{dm_wrap_tbl()}}, \code{\link[=dm_unnest_tbl]{dm_unnest_tbl()}},
\code{\link[=dm_examine_constraints]{dm_examine_constraints()}},
\code{\link[=dm_examine_cardinalities]{dm_examine_cardinalities()}},
\code{\link[=dm_ptype]{dm_ptype()}}.
}
