% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm.R
\name{dm}
\alias{dm}
\alias{new_dm}
\alias{is_dm}
\alias{as_dm}
\title{Data model class}
\usage{
dm(
  ...,
  .name_repair = c("check_unique", "unique", "universal", "minimal"),
  .quiet = FALSE
)

new_dm(tables = list())

is_dm(x)

as_dm(x, ...)
}
\arguments{
\item{...}{Tables or existing \code{dm} objects to add to the \code{dm} object.
Unnamed tables are auto-named, \code{dm} objects must not be named.}

\item{.name_repair, .quiet}{Options for name repair.
Forwarded as \code{repair} and \code{quiet} to \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}}.}

\item{tables}{A named list of the tables (tibble-objects, not names),
to be included in the \code{dm} object.}

\item{x}{An object.}
}
\value{
For \code{dm()}, \code{new_dm()}, \code{as_dm()}: A \code{dm} object.

For \code{is_dm()}: A scalar logical, \code{TRUE} if is this object is a \code{dm}.
}
\description{
The \code{dm} class holds a list of tables and their relationships.
It is inspired by \href{https://github.com/bergant/datamodelr}{datamodelr},
and extends the idea by offering operations to access the data in the tables.

\code{dm()} creates a \code{dm} object from \link{tbl} objects
(tibbles or lazy data objects).

\code{new_dm()} is a low-level constructor that creates a new \code{dm} object.
\itemize{
\item If called without arguments, it will create an empty \code{dm}.
\item If called with arguments, no validation checks will be made to ascertain that
the inputs are of the expected class and internally consistent;
use \code{\link[=dm_validate]{dm_validate()}} to double-check the returned object.
}

\code{is_dm()} returns \code{TRUE} if the input is of class \code{dm}.

\code{as_dm()} coerces objects to the \code{dm} class
}
\examples{
dm(trees, mtcars)

new_dm(list(trees = trees, mtcars = mtcars))

as_dm(list(trees = trees, mtcars = mtcars))
\dontshow{if (rlang::is_installed("nycflights13") && rlang::is_installed("dbplyr")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

is_dm(dm_nycflights13())

dm_nycflights13()$airports

dm_nycflights13()["airports"]

dm_nycflights13()[["airports"]]

dm_nycflights13() \%>\% names()
\dontshow{\}) # examplesIf}
\dontshow{if (rlang::is_installed("nycflights13")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dm)
library(nycflights13)

# using `data.frame` objects
new_dm(tibble::lst(weather, airports))

# using `dm_keyed_tbl` objects
dm <- dm_nycflights13()
y1 <- dm$planes \%>\%
  mutate() \%>\%
  select(everything())
y2 <- dm$flights \%>\%
  left_join(dm$airlines, by = "carrier")

new_dm(list("tbl1" = y1, "tbl2" = y2))
\dontshow{\}) # examplesIf}
}
\seealso{
\itemize{
\item \code{\link[=dm_from_con]{dm_from_con()}} for connecting to all tables in a database
and importing the primary and foreign keys
\item \code{\link[=dm_get_tables]{dm_get_tables()}} for returning a list of tables
\item \code{\link[=dm_add_pk]{dm_add_pk()}} and \code{\link[=dm_add_fk]{dm_add_fk()}} for adding primary and foreign keys
\item \code{\link[=copy_dm_to]{copy_dm_to()}} for DB interaction
\item \code{\link[=dm_draw]{dm_draw()}} for visualization
\item \code{\link[=dm_flatten_to_tbl]{dm_flatten_to_tbl()}} for flattening
\item \code{\link[=dm_filter]{dm_filter()}} for filtering
\item \code{\link[=dm_select_tbl]{dm_select_tbl()}} for creating a \code{dm} with only a subset of the tables
\item \code{\link[=dm_nycflights13]{dm_nycflights13()}}  for creating an example \code{dm} object
\item \code{\link[=decompose_table]{decompose_table()}} for table surgery
\item \code{\link[=check_key]{check_key()}} and \code{\link[=check_subset]{check_subset()}} for checking for key properties
\item \code{\link[=examine_cardinality]{examine_cardinality()}} for checking the cardinality of the relation between two tables
}
}
