% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw-dm.R
\name{dm_draw}
\alias{dm_draw}
\title{Draw a diagram of the data model}
\usage{
dm_draw(
  dm,
  rankdir = "LR",
  ...,
  col_attr = NULL,
  view_type = c("keys_only", "all", "title_only"),
  columnArrows = TRUE,
  graph_attrs = "",
  node_attrs = "",
  edge_attrs = "",
  focus = NULL,
  graph_name = "Data Model",
  column_types = NULL,
  backend = "DiagrammeR",
  font_size = NULL
)
}
\arguments{
\item{dm}{A \code{\link{dm}} object.}

\item{rankdir}{Graph attribute for direction (e.g., 'BT' = bottom --> top).}

\item{...}{These dots are for future extensions and must be empty.}

\item{col_attr}{Deprecated, use \code{colummn_types} instead.}

\item{view_type}{Can be "keys_only" (default), "all" or "title_only".
It defines the level of details for rendering tables
(only primary and foreign keys, all columns, or no columns).}

\item{columnArrows}{Edges from columns to columns (default: \code{TRUE}).}

\item{graph_attrs}{Additional graph attributes.}

\item{node_attrs}{Additional node attributes.}

\item{edge_attrs}{Additional edge attributes.}

\item{focus}{A list of parameters for rendering (table filter).}

\item{graph_name}{The name of the graph.}

\item{column_types}{Set to \code{TRUE} to show column types.}

\item{backend}{Currently, only the default \code{"DiagrammeR"} is accepted.
Pass this value explicitly if your code not only uses this function
to display a data model but relies on the type of the return value.}

\item{font_size}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Font size for:
- \code{header}, defaults to \code{16}
- \code{column}, defaults to \code{16}
- \code{table_description}, defaults to \code{8}

Can be set as a named integer vector, e.g. \code{c(table_headers = 18L, table_description = 6L)}.}
}
\value{
An object with a \code{\link[=print]{print()}} method, which,
when printed, produces the output seen in the viewer as a side effect.
Currently, this is an object of class \code{grViz} (see also
\code{\link[DiagrammeR:grViz]{DiagrammeR::grViz()}}), but this is subject to change.
}
\description{
\code{dm_draw()} draws a diagram, a visual representation of the data model.
}
\details{
Currently, \pkg{dm} uses \pkg{DiagrammeR} to draw diagrams.
Use \code{\link[DiagrammeRsvg:export_svg]{DiagrammeRsvg::export_svg()}} to convert the diagram to an SVG file.

The backend for drawing the diagrams might change in the future.
If you rely on DiagrammeR, pass an explicit value for the \code{backend} argument.
}
\examples{
\dontshow{if (rlang::is_installed("nycflights13") && rlang::is_installed("DiagrammeR")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dm_nycflights13() \%>\%
  dm_draw()

dm_nycflights13(cycle = TRUE) \%>\%
  dm_draw(view_type = "title_only")

head(dm_get_available_colors())
length(dm_get_available_colors())

dm_nycflights13() \%>\%
  dm_get_colors()
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=dm_set_colors]{dm_set_colors()}} for defining the table colors.

\code{\link[=dm_set_table_description]{dm_set_table_description()}} for adding details to one or more tables in the diagram
}
