% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm_get_tables.R
\name{dm_get_tables}
\alias{dm_get_tables}
\title{Get tables}
\usage{
dm_get_tables(x, ..., keyed = FALSE)
}
\arguments{
\item{x}{A \code{dm} object.}

\item{...}{These dots are for future extensions and must be empty.}

\item{keyed}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Set to \code{TRUE} to return objects of the internal class \code{"dm_keyed_tbl"}
that will contain information on primary and foreign keys
in the individual table objects.
This allows using dplyr workflows on those tables and later reconstruct them
into a \code{dm} object.
See \code{\link[=dm_deconstruct]{dm_deconstruct()}} for a function that generates corresponding code
for an existing dm object, and \code{vignette("tech-dm-keyed")} for details.}
}
\value{
A named list with the tables (data frames or lazy tables)
constituting the \code{dm}.
}
\description{
\code{dm_get_tables()} returns a named list of \pkg{dplyr} \link{tbl} objects
of a \code{dm} object.
}
\examples{
dm_nycflights13() \%>\%
  dm_get_tables()

dm_nycflights13() \%>\%
  dm_get_tables(keyed = TRUE)

dm_nycflights13() \%>\%
  dm_get_tables(keyed = TRUE) \%>\%
  new_dm()
}
\seealso{
\code{\link[=dm]{dm()}} and \code{\link[=new_dm]{new_dm()}} for constructing a \code{dm} object from tables.
}
