% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmds.R
\name{comp_ssr}
\alias{comp_ssr}
\title{Sum of squared residuals (SSR) from the observed distances and the given
latent configuration.}
\usage{
comp_ssr(x, diss)
}
\arguments{
\item{x}{Real matrix containing the latent configuration.}

\item{diss}{Observed dissimilarities (provided as a distance matrix).}
}
\value{
A length-one numeric vector providing the SSR for its arguments.
}
\description{
\code{comp_ssr} computes the sum of squared residuals (SSR) from the
  observed distances (\code{diss}) and the given latent coordinates
  (\code{x}).
}
\examples{
n <- 10000
nr <- 200
nc <- floor(n/nr)
x <- matrix(rnorm(1:n), nrow = nr, ncol = nc)
obsdiss <- dist(x)
ssr <- numeric(ncol(x))
for (i in 1:ncol(x)) {
  ssr[i] <- comp_ssr(x[, 1:i], obsdiss)
}
plot(ssr, xlab = "number of dimensions", ylab = "SSR", type = "b")
}
\seealso{
\code{\link{bmds}} for (one-way) Bayesian (metric) multidimensional
  scaling.
}
\author{
Sergio Venturini \email{sergio.venturini@unito.it}
}
