% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmbc-package.R
\docType{data}
\name{kinship}
\alias{kinship}
\title{List of binary dissimilarity matrices among 15 kinship terms.}
\format{
{
  A \code{\link{dmbc_data}} object whose \code{diss} element is a list of 85
  binary dissimilarity matrices. Each matrix is defined as a \code{dist}
  object measuring whether each pair of the 15 kinship terms is judged as
  similar (1) or not (0).

  The \code{dist} objects have rows and columns that are named as follows:
  \describe{
    \item{GrF}{grandfather}
    \item{GrM}{grandmother}
    \item{GrD}{granddaughter}
    \item{GrS}{grandson}
    \item{Bro}{brother}
    \item{Sis}{sister}
    \item{Fat}{father}
    \item{Mot}{mother}
    \item{Dau}{daughter}
    \item{Son}{son}
    \item{Nep}{nephew}
    \item{Nie}{niece}
    \item{Cou}{cousin}
    \item{Aun}{aunt}
    \item{Unc}{uncle}
  }
}
}
\usage{
data(kinship)
}
\description{
{
Rosenberg and Kim (1975) designed an experiment to analyze the perceived
  similarities of 15 kinship terms.

  Here, we consider the data relative to 85 females made available in
  Rosenberg (1982). Each subject was asked to group the kinship terms
  according to the perceived similarity. Thus, \emph{S} = 85 binary
  dissimilarity matrices are available whose elements (0 or 1) indicate
  whether or not two kinship terms were grouped together by each individual.
}
}
\examples{
data(kinship)
library(bayesplot)
cols <- color_scheme_set("mix-red-blue")
plot(kinship, colors = unlist(cols)[c(1, 6)], font = 1, cex.font = 0.75)
}
\references{
{
  Rosenberg, S. (1982). The method of sorting in multivariate research with
    applications selected from cognitive psychology and person perception. In
    N Hirschberg, LG Humphreys (eds.), Multivariate Applications in the Social
    Sciences, pp. 117–142. Erlbaum., Hillsdale, NJ.

  Rosenberg, S., Kim, M. P. (1975). The method of sorting as a data-gathering
    procedure in multivariate research. Multivariate Behavioral Research, 10.
}
}
\keyword{datasets}
