% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateVertex.R
\name{engineVertex}
\alias{engineVertex}
\title{Simulation Engine for dynamic Vertex case.}
\usage{
engineVertex(InputNetwork, numSim, maxLag, VertexStatsvec = rep(1,
  nvertexstats), VertexLag = rep(1, maxLag), VertexLagMatrix = matrix(1,
  maxLag, length(VertexStatsvec)), VertexModelGroup = NA,
  VertexAttLag = rep(1, maxLag), dayClassObserved = NA,
  dayClassFuture = NA, EdgeModelTerms, EdgeModelFormula, EdgeGroup = NA,
  EdgeIntercept = c("edges"), EdgeNetparam = NA, EdgeExvar = NA,
  EdgeLag = rep(1, maxLag), EdgeLagMatrix = matrix(1, maxLag,
  length(EdgeModelTerms)), regMethod = "bayesglm", paramout = TRUE)
}
\arguments{
\item{InputNetwork}{List of input networks}

\item{numSim}{number of time points to simulate}

\item{maxLag}{maximum Lag}

\item{VertexStatsvec}{Binary vector for vertex model.}

\item{VertexLag}{vector of lag for vertex}

\item{VertexLagMatrix}{matrix of lags for vertex stats.}

\item{VertexModelGroup}{Group term for vertex model.}

\item{VertexAttLag}{Lag vector for group term for vertex.}

\item{dayClassObserved}{Observed day class.}

\item{dayClassFuture}{Dayclass vector for future, must be of size numsim.}

\item{EdgeModelTerms}{Edge Model terms}

\item{EdgeModelFormula}{Edge model formula}

\item{EdgeGroup}{edge group term}

\item{EdgeIntercept}{edge intercept}

\item{EdgeNetparam}{edge network parameter name}

\item{EdgeExvar}{edge extraneous variable}

\item{EdgeLag}{edge Lag vector}

\item{EdgeLagMatrix}{edge lag matrix}

\item{regMethod}{regression method. "bayesglm" by default}

\item{paramout}{T/F on if regression needs to run.}
}
\value{
List with following elements:
SimNetwork: Output Networks
EdgeParameterMat: Matrix of edge parameter
VertexParameterMat: Matrix of Vertex parameters.
}
\description{
Simulation engine for dynamic networks with variable number of vertices. 
Implements exponential family based hierachical model for vertice and the edges.
}
\examples{
\dontrun{
nvertexstats <- 9
maxLag = 3
VertexLag = rep(1, maxLag)
VertexLagMatrix <- matrix(0, maxLag, nvertexstats)
VertexLagMatrix[, c(4, 7)] <- 1
VertexLagMatrix[c(2,3),7] <- 0

getWeekend <- function(z){
    weekends <- c("Saturday", "Sunday")
    if(!network::is.network(z)){
        if(is.na(z)) return(NA)
    } else {
         zDay <- get.network.attribute(z, attrname = "day")
         out <- ifelse(zDay \%in\% weekends, 1, 0)
         return(out)   
    }
}

dayClass <- numeric(length(beach))
for(i in seq_along(dayClass)) {
    dayClass[i] <- getWeekend(beach[[i]])
}
dayClass <- na.omit(dayClass)
simResult <- suppressWarnings(engineVertex(InputNetwork = beach,
                          numSim = 5,
                          maxLag = 3,
                          VertexStatsvec = rep(1, nvertexstats),
                          VertexModelGroup = "regular",
                          VertexAttLag = rep(1, maxLag),
                          VertexLag = rep(1, maxLag),
                          VertexLagMatrix = VertexLagMatrix,
                          dayClassObserved = dayClass,
                          dayClassFuture = c(1, 0, 0, 0, 0),
                          EdgeModelTerms = NA,
                          EdgeModelFormula = NA,
                          EdgeGroup = NA,
                          EdgeIntercept = c("edges"),
                          EdgeNetparam = c("logSize"),
                          EdgeExvar = NA,
                          EdgeLag = c(0, 1, 0),
                          paramout = TRUE
                          ))}

}
\author{
Abhirup
}
